/*
 * Decompiled with CFR 0.152.
 */
package no.nav.common.kafka.producer;

import java.util.Properties;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import no.nav.common.kafka.producer.GracefulKafkaProducer;
import no.nav.common.kafka.producer.KafkaProducerClient;
import org.apache.kafka.clients.producer.Callback;
import org.apache.kafka.clients.producer.Producer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KafkaProducerClientImpl<K, V>
implements KafkaProducerClient<K, V> {
    private final Logger log = LoggerFactory.getLogger(KafkaProducerClientImpl.class);
    private final Producer<K, V> producer;

    public KafkaProducerClientImpl(Producer<K, V> producer) {
        this.producer = producer;
    }

    public KafkaProducerClientImpl(Properties properties) {
        this((Producer<K, V>)new GracefulKafkaProducer(properties));
    }

    @Override
    public void close() {
        this.log.info("Closing kafka producer...");
        this.producer.close();
    }

    @Override
    public RecordMetadata sendSync(ProducerRecord<K, V> record) {
        Future<RecordMetadata> future = this.send(record, null);
        this.producer.flush();
        return future.get();
    }

    @Override
    public Future<RecordMetadata> send(ProducerRecord<K, V> record) {
        return this.send(record, null);
    }

    @Override
    public Future<RecordMetadata> send(ProducerRecord<K, V> record, Callback callback) {
        Callback callbackWithLog = this.wrapWithLog(callback);
        try {
            return this.producer.send(record, callbackWithLog);
        }
        catch (Exception e) {
            callbackWithLog.onCompletion(null, e);
            return CompletableFuture.failedFuture(e);
        }
    }

    @Override
    public Producer<K, V> getProducer() {
        return this.producer;
    }

    private Callback wrapWithLog(Callback callback) {
        return (metadata, exception) -> {
            if (metadata != null) {
                this.log.info("Record was sent topic={} partition={} offset={}", new Object[]{metadata.topic(), metadata.partition(), metadata.offset()});
            } else if (exception != null) {
                this.log.error("Failed to send record", (Throwable)exception);
            }
            if (callback != null) {
                callback.onCompletion(metadata, exception);
            }
        };
    }
}

