/*
 * Decompiled with CFR 0.152.
 */
package no.nav.common.kafka.consumer.feilhandtering;

import no.nav.common.kafka.consumer.ConsumeStatus;
import no.nav.common.kafka.consumer.TopicConsumer;
import no.nav.common.kafka.consumer.feilhandtering.KafkaConsumerRepository;
import no.nav.common.kafka.consumer.util.ConsumerUtils;
import org.apache.kafka.clients.consumer.ConsumerRecord;

public class StoreOnFailureTopicConsumer
implements TopicConsumer<byte[], byte[]> {
    private final TopicConsumer<byte[], byte[]> consumer;
    private final KafkaConsumerRepository consumerRepository;

    public StoreOnFailureTopicConsumer(TopicConsumer<byte[], byte[]> consumer, KafkaConsumerRepository consumerRepository) {
        this.consumer = consumer;
        this.consumerRepository = consumerRepository;
    }

    @Override
    public ConsumeStatus consume(ConsumerRecord<byte[], byte[]> record) {
        ConsumeStatus status;
        boolean shouldConsumeRecord;
        boolean bl = shouldConsumeRecord = record.key() == null || !this.consumerRepository.hasRecordWithKey(record.topic(), record.partition(), (byte[])record.key());
        if (shouldConsumeRecord && (status = ConsumerUtils.safeConsume(this.consumer, record)) == ConsumeStatus.OK) {
            return ConsumeStatus.OK;
        }
        this.consumerRepository.storeRecord(ConsumerUtils.mapToStoredRecord(record));
        return ConsumeStatus.OK;
    }
}

