/*
 * Decompiled with CFR 0.152.
 */
package no.nav.common.kafka.consumer.util;

import no.nav.common.kafka.consumer.ConsumeStatus;
import no.nav.common.kafka.consumer.util.TopicConsumerListener;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TopicConsumerLogger<K, V>
implements TopicConsumerListener<K, V> {
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    @Override
    public void onConsumed(ConsumerRecord<K, V> record, ConsumeStatus status) {
        if (status == ConsumeStatus.OK) {
            this.log.info("Consumed record topic={} partition={} offset={}", new Object[]{record.topic(), record.partition(), record.offset()});
        } else {
            this.log.error("Failed to consume record topic={} partition={} offset={}", new Object[]{record.topic(), record.partition(), record.offset()});
        }
    }
}

