/*
 * Decompiled with CFR 0.152.
 */
package no.nav.common.kafka.consumer.feilhandtering.util;

import java.time.Duration;
import java.util.List;
import net.javacrumbs.shedlock.core.LockProvider;
import no.nav.common.kafka.consumer.feilhandtering.KafkaConsumerRecordProcessor;
import no.nav.common.kafka.consumer.feilhandtering.KafkaConsumerRecordProcessorConfig;
import no.nav.common.kafka.consumer.feilhandtering.KafkaConsumerRepository;
import no.nav.common.kafka.consumer.feilhandtering.backoff.BackoffStrategy;
import no.nav.common.kafka.consumer.feilhandtering.backoff.LinearBackoffStrategy;
import no.nav.common.kafka.consumer.util.ConsumerUtils;
import no.nav.common.kafka.consumer.util.TopicConsumerConfig;

public class KafkaConsumerRecordProcessorBuilder {
    private static final Duration DEFAULT_ERROR_TIMEOUT = Duration.ofMinutes(5L);
    private static final Duration DEFAULT_POLL_TIMEOUT = Duration.ofMinutes(1L);
    private static final int DEFAULT_RECORDS_BATCH_SIZE = 100;
    private static final BackoffStrategy DEFAULT_RETRY_BACKOFF_STRATEGY = new LinearBackoffStrategy(0, 43200, 144);
    private LockProvider lockProvider;
    private KafkaConsumerRepository kafkaConsumerRepository;
    private List<TopicConsumerConfig<?, ?>> topicConsumerConfigs;
    private final KafkaConsumerRecordProcessorConfig config = new KafkaConsumerRecordProcessorConfig(DEFAULT_ERROR_TIMEOUT, DEFAULT_POLL_TIMEOUT, 100, DEFAULT_RETRY_BACKOFF_STRATEGY);

    private KafkaConsumerRecordProcessorBuilder() {
    }

    public static KafkaConsumerRecordProcessorBuilder builder() {
        return new KafkaConsumerRecordProcessorBuilder();
    }

    public KafkaConsumerRecordProcessorBuilder withLockProvider(LockProvider lockProvider) {
        this.lockProvider = lockProvider;
        return this;
    }

    public KafkaConsumerRecordProcessorBuilder withKafkaConsumerRepository(KafkaConsumerRepository kafkaConsumerRepository) {
        this.kafkaConsumerRepository = kafkaConsumerRepository;
        return this;
    }

    public KafkaConsumerRecordProcessorBuilder withConsumerConfigs(List<TopicConsumerConfig<?, ?>> topicConsumerConfigs) {
        this.topicConsumerConfigs = topicConsumerConfigs;
        return this;
    }

    public KafkaConsumerRecordProcessorBuilder withErrorTimeout(Duration errorTimeout) {
        this.config.setErrorTimeout(errorTimeout);
        return this;
    }

    public KafkaConsumerRecordProcessorBuilder withPollTimeout(Duration pollTimeout) {
        this.config.setPollTimeout(pollTimeout);
        return this;
    }

    public KafkaConsumerRecordProcessorBuilder withRecordBatchSize(int recordBatchSize) {
        this.config.setRecordBatchSize(recordBatchSize);
        return this;
    }

    public KafkaConsumerRecordProcessorBuilder withBackoffStrategy(BackoffStrategy backoffStrategy) {
        this.config.setBackoffStrategy(backoffStrategy);
        return this;
    }

    public KafkaConsumerRecordProcessor build() {
        if (this.lockProvider == null) {
            throw new IllegalStateException("Cannot build kafka consumer record processor without lockProvider");
        }
        if (this.kafkaConsumerRepository == null) {
            throw new IllegalStateException("Cannot build kafka consumer record processor without kafkaConsumerRepository");
        }
        if (this.topicConsumerConfigs == null) {
            throw new IllegalStateException("Cannot build kafka consumer record processor without recordConsumers");
        }
        if (this.config.getErrorTimeout() == null) {
            throw new IllegalStateException("Cannot build kafka consumer record processor without config.errorTimeout");
        }
        if (this.config.getPollTimeout() == null) {
            throw new IllegalStateException("Cannot build kafka consumer record processor without config.pollTimeout");
        }
        if (this.config.getBackoffStrategy() == null) {
            throw new IllegalStateException("Cannot build kafka consumer record processor without config.retryBackoffStrategy");
        }
        return new KafkaConsumerRecordProcessor(this.lockProvider, this.kafkaConsumerRepository, ConsumerUtils.createTopicConsumers(this.topicConsumerConfigs), this.config);
    }
}

