/*
 * Decompiled with CFR 0.152.
 */
package no.nav.common.kafka.spring;

import java.sql.ResultSet;
import java.util.List;
import no.nav.common.kafka.consumer.feilhandtering.KafkaConsumerRepository;
import no.nav.common.kafka.consumer.feilhandtering.StoredConsumerRecord;
import no.nav.common.kafka.spring.DatabaseUtils;
import org.apache.kafka.common.TopicPartition;
import org.springframework.dao.DuplicateKeyException;
import org.springframework.jdbc.core.JdbcTemplate;

public class PostgresJdbcTemplateConsumerRepository
implements KafkaConsumerRepository {
    private final JdbcTemplate jdbcTemplate;
    private final String consumerRecordTable;

    public PostgresJdbcTemplateConsumerRepository(JdbcTemplate jdbcTemplate, String consumerRecordTable) {
        this.jdbcTemplate = jdbcTemplate;
        this.consumerRecordTable = consumerRecordTable;
    }

    public PostgresJdbcTemplateConsumerRepository(JdbcTemplate jdbcTemplate) {
        this(jdbcTemplate, "KAFKA_CONSUMER_RECORD");
    }

    @Override
    public long storeRecord(StoredConsumerRecord record) {
        String sql = String.format("INSERT INTO %s (%s, %s, %s, %s, %s, %s, %s, %s) VALUES (?, ?, ?, ?, ?, ?, ?, ?)", this.consumerRecordTable, "ID", "TOPIC", "PARTITION", "RECORD_OFFSET", "KEY", "VALUE", "HEADERS_JSON", "RECORD_TIMESTAMP");
        long id = DatabaseUtils.incrementAndGetPostgresSequence(this.jdbcTemplate, "KAFKA_CONSUMER_RECORD_ID_SEQ");
        try {
            this.jdbcTemplate.update(sql, new Object[]{id, record.getTopic(), record.getPartition(), record.getOffset(), record.getKey(), record.getValue(), record.getHeadersJson(), record.getTimestamp()});
            return id;
        }
        catch (DuplicateKeyException e) {
            return -1L;
        }
    }

    @Override
    public void deleteRecords(List<Long> ids) {
        String sql = String.format("DELETE FROM %s WHERE %s = ANY(?::bigint[])", this.consumerRecordTable, "ID");
        this.jdbcTemplate.update(sql, new Object[]{DatabaseUtils.toPostgresArray(ids)});
    }

    @Override
    public boolean hasRecordWithKey(String topic, int partition, byte[] key) {
        String sql = String.format("SELECT %s FROM %s WHERE %s = ? AND %s = ? AND %s = ? LIMIT 1", "ID", this.consumerRecordTable, "TOPIC", "PARTITION", "KEY");
        return (Boolean)this.jdbcTemplate.query(sql, ResultSet::next, new Object[]{topic, partition, key});
    }

    @Override
    public List<StoredConsumerRecord> getRecords(String topic, int partition, int maxRecords) {
        String sql = String.format("SELECT * FROM %s WHERE %s = ? AND %s = ? ORDER BY %s LIMIT %d", this.consumerRecordTable, "TOPIC", "PARTITION", "RECORD_OFFSET", maxRecords);
        return (List)this.jdbcTemplate.query(sql, DatabaseUtils::fetchConsumerRecords, new Object[]{topic, partition});
    }

    @Override
    public void incrementRetries(long id) {
        String sql = String.format("UPDATE %s SET %s = %s + 1, %s = CURRENT_TIMESTAMP WHERE %s = ?", this.consumerRecordTable, "RETRIES", "RETRIES", "LAST_RETRY", "ID");
        this.jdbcTemplate.update(sql, new Object[]{id});
    }

    @Override
    public List<TopicPartition> getTopicPartitions(List<String> topics) {
        String sql = String.format("SELECT DISTINCT %s, %s FROM %s WHERE %s = ANY(?::varchar[])", "TOPIC", "PARTITION", this.consumerRecordTable, "TOPIC");
        return (List)this.jdbcTemplate.query(sql, DatabaseUtils::fetchTopicPartitions, new Object[]{DatabaseUtils.toPostgresArray(topics)});
    }
}

