/*
 * Decompiled with CFR 0.152.
 */
package no.nav.common.kafka.consumer.feilhandtering;

import no.nav.common.kafka.consumer.ConsumeStatus;
import no.nav.common.kafka.consumer.TopicConsumer;
import no.nav.common.kafka.consumer.feilhandtering.KafkaConsumerRepository;
import no.nav.common.kafka.consumer.util.ConsumerUtils;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StoreRecordTopicConsumer
implements TopicConsumer<byte[], byte[]> {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final KafkaConsumerRepository consumerRepository;

    public StoreRecordTopicConsumer(KafkaConsumerRepository consumerRepository) {
        this.consumerRepository = consumerRepository;
    }

    @Override
    public ConsumeStatus consume(ConsumerRecord<byte[], byte[]> record) {
        try {
            this.consumerRepository.storeRecord(ConsumerUtils.mapToStoredRecord(record));
            this.log.info("Stored consumer record topic={} partition={} offset={}", new Object[]{record.topic(), record.partition(), record.offset()});
            return ConsumeStatus.OK;
        }
        catch (Exception e) {
            String msg = String.format("Failed to store consumer record topic=%s, partition=%d offset=%d", record.topic(), record.partition(), record.offset());
            this.log.error(msg, (Throwable)e);
            return ConsumeStatus.FAILED;
        }
    }
}

