/*
 * Decompiled with CFR 0.152.
 */
package no.nav.common.kafka.consumer.feilhandtering;

import java.sql.Timestamp;
import java.util.Arrays;

public class StoredConsumerRecord {
    private final long id;
    private final String topic;
    private final int partition;
    private final long offset;
    private final byte[] key;
    private final byte[] value;
    private final String headersJson;
    private final int retries;
    private final Timestamp lastRetry;
    private final long timestamp;

    public StoredConsumerRecord(String topic, int partition, long offset, byte[] key, byte[] value, String headersJson, long timestamp) {
        this.id = -1L;
        this.topic = topic;
        this.partition = partition;
        this.offset = offset;
        this.key = key;
        this.value = value;
        this.headersJson = headersJson;
        this.timestamp = timestamp;
        this.retries = 0;
        this.lastRetry = null;
    }

    public StoredConsumerRecord(long id, String topic, int partition, long offset, byte[] key, byte[] value, String headersJson, int retries, Timestamp lastRetry, long timestamp) {
        this.id = id;
        this.topic = topic;
        this.partition = partition;
        this.offset = offset;
        this.key = key;
        this.value = value;
        this.headersJson = headersJson;
        this.retries = retries;
        this.lastRetry = lastRetry;
        this.timestamp = timestamp;
    }

    public long getId() {
        return this.id;
    }

    public String getTopic() {
        return this.topic;
    }

    public int getPartition() {
        return this.partition;
    }

    public long getOffset() {
        return this.offset;
    }

    public byte[] getKey() {
        return this.key;
    }

    public byte[] getValue() {
        return this.value;
    }

    public String getHeadersJson() {
        return this.headersJson;
    }

    public int getRetries() {
        return this.retries;
    }

    public Timestamp getLastRetry() {
        return this.lastRetry;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof StoredConsumerRecord)) {
            return false;
        }
        StoredConsumerRecord other = (StoredConsumerRecord)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getId() != other.getId()) {
            return false;
        }
        if (this.getPartition() != other.getPartition()) {
            return false;
        }
        if (this.getOffset() != other.getOffset()) {
            return false;
        }
        if (this.getRetries() != other.getRetries()) {
            return false;
        }
        if (this.getTimestamp() != other.getTimestamp()) {
            return false;
        }
        String this$topic = this.getTopic();
        String other$topic = other.getTopic();
        if (this$topic == null ? other$topic != null : !this$topic.equals(other$topic)) {
            return false;
        }
        if (!Arrays.equals(this.getKey(), other.getKey())) {
            return false;
        }
        if (!Arrays.equals(this.getValue(), other.getValue())) {
            return false;
        }
        String this$headersJson = this.getHeadersJson();
        String other$headersJson = other.getHeadersJson();
        if (this$headersJson == null ? other$headersJson != null : !this$headersJson.equals(other$headersJson)) {
            return false;
        }
        Timestamp this$lastRetry = this.getLastRetry();
        Timestamp other$lastRetry = other.getLastRetry();
        return !(this$lastRetry == null ? other$lastRetry != null : !((Object)this$lastRetry).equals(other$lastRetry));
    }

    protected boolean canEqual(Object other) {
        return other instanceof StoredConsumerRecord;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $id = this.getId();
        result = result * 59 + (int)($id >>> 32 ^ $id);
        result = result * 59 + this.getPartition();
        long $offset = this.getOffset();
        result = result * 59 + (int)($offset >>> 32 ^ $offset);
        result = result * 59 + this.getRetries();
        long $timestamp = this.getTimestamp();
        result = result * 59 + (int)($timestamp >>> 32 ^ $timestamp);
        String $topic = this.getTopic();
        result = result * 59 + ($topic == null ? 43 : $topic.hashCode());
        result = result * 59 + Arrays.hashCode(this.getKey());
        result = result * 59 + Arrays.hashCode(this.getValue());
        String $headersJson = this.getHeadersJson();
        result = result * 59 + ($headersJson == null ? 43 : $headersJson.hashCode());
        Timestamp $lastRetry = this.getLastRetry();
        result = result * 59 + ($lastRetry == null ? 43 : ((Object)$lastRetry).hashCode());
        return result;
    }

    public String toString() {
        return "StoredConsumerRecord(id=" + this.getId() + ", topic=" + this.getTopic() + ", partition=" + this.getPartition() + ", offset=" + this.getOffset() + ", key=" + Arrays.toString(this.getKey()) + ", value=" + Arrays.toString(this.getValue()) + ", headersJson=" + this.getHeadersJson() + ", retries=" + this.getRetries() + ", lastRetry=" + this.getLastRetry() + ", timestamp=" + this.getTimestamp() + ")";
    }
}

