/*
 * Decompiled with CFR 0.152.
 */
package no.nav.common.kafka.spring;

import java.sql.ResultSet;
import java.util.List;
import no.nav.common.kafka.consumer.feilhandtering.KafkaConsumerRepository;
import no.nav.common.kafka.consumer.feilhandtering.StoredConsumerRecord;
import no.nav.common.kafka.spring.DatabaseUtils;
import org.apache.kafka.common.TopicPartition;
import org.springframework.dao.DuplicateKeyException;
import org.springframework.jdbc.core.JdbcTemplate;

public class OracleJdbcTemplateConsumerRepository
implements KafkaConsumerRepository {
    private final JdbcTemplate jdbcTemplate;
    private final String consumerRecordTable;

    public OracleJdbcTemplateConsumerRepository(JdbcTemplate jdbcTemplate, String consumerRecordTable) {
        this.jdbcTemplate = jdbcTemplate;
        this.consumerRecordTable = consumerRecordTable;
    }

    public OracleJdbcTemplateConsumerRepository(JdbcTemplate jdbcTemplate) {
        this(jdbcTemplate, "KAFKA_CONSUMER_RECORD");
    }

    @Override
    public long storeRecord(StoredConsumerRecord record) {
        String sql = String.format("INSERT INTO %s (%s, %s, %s, %s, %s, %s, %s, %s) VALUES (?, ?, ?, ?, ?, ?, ?, ?)", this.consumerRecordTable, "ID", "TOPIC", "PARTITION", "RECORD_OFFSET", "KEY", "VALUE", "HEADERS_JSON", "RECORD_TIMESTAMP");
        long id = DatabaseUtils.incrementAndGetOracleSequence(this.jdbcTemplate, "KAFKA_CONSUMER_RECORD_ID_SEQ");
        try {
            this.jdbcTemplate.update(sql, new Object[]{id, record.getTopic(), record.getPartition(), record.getOffset(), record.getKey(), record.getValue(), record.getHeadersJson(), record.getTimestamp()});
        }
        catch (DuplicateKeyException e) {
            return -1L;
        }
        return id;
    }

    @Override
    public void deleteRecords(List<Long> ids) {
        String sql = String.format("DELETE FROM %s WHERE %s " + DatabaseUtils.inClause(ids.size()), this.consumerRecordTable, "ID");
        this.jdbcTemplate.update(sql, ids.toArray());
    }

    @Override
    public boolean hasRecordWithKey(String topic, int partition, byte[] key) {
        String sql = String.format("SELECT %s FROM %s WHERE %s = ? AND %s = ? AND dbms_lob.compare(%s, ?) = 0 FETCH NEXT 1 ROWS ONLY", "ID", this.consumerRecordTable, "TOPIC", "PARTITION", "KEY");
        return (Boolean)this.jdbcTemplate.query(sql, ResultSet::next, new Object[]{topic, partition, key});
    }

    @Override
    public List<StoredConsumerRecord> getRecords(String topic, int partition, int maxRecords) {
        String sql = String.format("SELECT * FROM %s WHERE %s = ? AND %s = ? ORDER BY %s FETCH NEXT %d ROWS ONLY", this.consumerRecordTable, "TOPIC", "PARTITION", "RECORD_OFFSET", maxRecords);
        return (List)this.jdbcTemplate.query(sql, DatabaseUtils::fetchConsumerRecords, new Object[]{topic, partition});
    }

    @Override
    public void incrementRetries(long id) {
        String sql = String.format("UPDATE %s SET %s = %s + 1, %s = CURRENT_TIMESTAMP WHERE %s = ?", this.consumerRecordTable, "RETRIES", "RETRIES", "LAST_RETRY", "ID");
        this.jdbcTemplate.update(sql, new Object[]{id});
    }

    @Override
    public List<TopicPartition> getTopicPartitions(List<String> topics) {
        String sql = String.format("SELECT DISTINCT %s, %s FROM %s WHERE %s " + DatabaseUtils.inClause(topics.size()), "TOPIC", "PARTITION", this.consumerRecordTable, "TOPIC");
        return (List)this.jdbcTemplate.query(sql, DatabaseUtils::fetchTopicPartitions, topics.toArray());
    }
}

