/*
 * Decompiled with CFR 0.152.
 */
package no.nav.common.kafka.consumer.feilhandtering.backoff;

import java.time.Duration;
import no.nav.common.kafka.consumer.feilhandtering.StoredConsumerRecord;
import no.nav.common.kafka.consumer.feilhandtering.backoff.BackoffStrategy;
import no.nav.common.utils.MathUtils;

public class LinearBackoffStrategy
implements BackoffStrategy {
    private final int minBackoffSeconds;
    private final int maxBackoffSeconds;
    private final int maxBackoffAfterRetries;

    public LinearBackoffStrategy(int minBackoffSeconds, int maxBackoffSeconds, int maxBackoffAfterRetries) {
        this.minBackoffSeconds = minBackoffSeconds;
        this.maxBackoffSeconds = maxBackoffSeconds;
        this.maxBackoffAfterRetries = maxBackoffAfterRetries;
    }

    @Override
    public Duration getBackoffDuration(StoredConsumerRecord record) {
        int clampedRetry = MathUtils.clamp((int)record.getRetries(), (int)0, (int)this.maxBackoffAfterRetries);
        float percentBackoff = (float)clampedRetry / (float)this.maxBackoffAfterRetries;
        long secondsBackoff = MathUtils.linearInterpolation((long)this.minBackoffSeconds, (long)this.maxBackoffSeconds, (float)percentBackoff);
        return Duration.ofSeconds(secondsBackoff);
    }
}

