/*
 * Decompiled with CFR 0.152.
 */
package no.nav.common.kafka.consumer.util.deserializer;

import io.confluent.kafka.schemaregistry.client.CachedSchemaRegistryClient;
import io.confluent.kafka.schemaregistry.client.SchemaRegistryClient;
import io.confluent.kafka.serializers.KafkaAvroDeserializer;
import java.util.HashMap;
import java.util.Map;
import org.apache.kafka.common.serialization.Deserializer;

public class AvroDeserializer<T>
implements Deserializer<T> {
    private static final Map<String, SchemaRegistryClient> SCHEMA_REGISTRY_CLIENTS = new HashMap<String, SchemaRegistryClient>();
    private static final int SCHEMA_MAP_CAPACITY = 100;
    private final KafkaAvroDeserializer kafkaAvroDeserializer;

    public AvroDeserializer(String schemaRegistryUrl, String username, String password) {
        SchemaRegistryClient schemaRegistryClient = SCHEMA_REGISTRY_CLIENTS.computeIfAbsent(schemaRegistryUrl, url -> {
            HashMap<String, String> configs = new HashMap<String, String>();
            configs.put("basic.auth.credentials.source", "USER_INFO");
            configs.put("basic.auth.user.info", String.format("%s:%s", username, password));
            return new CachedSchemaRegistryClient(schemaRegistryUrl, 100, configs);
        });
        this.kafkaAvroDeserializer = new KafkaAvroDeserializer(schemaRegistryClient);
    }

    public AvroDeserializer(String schemaRegistryUrl) {
        this(schemaRegistryUrl, Map.of());
    }

    public AvroDeserializer(String schemaRegistryUrl, Map<String, ?> props) {
        SchemaRegistryClient schemaRegistryClient = SCHEMA_REGISTRY_CLIENTS.computeIfAbsent(schemaRegistryUrl, url -> new CachedSchemaRegistryClient(schemaRegistryUrl, 100));
        this.kafkaAvroDeserializer = new KafkaAvroDeserializer(schemaRegistryClient, props);
    }

    public void configure(Map<String, ?> props, boolean isKey) {
        this.kafkaAvroDeserializer.configure(props, isKey);
    }

    public T deserialize(String topic, byte[] data) {
        return (T)this.kafkaAvroDeserializer.deserialize(topic, data);
    }
}

