/*
 * Decompiled with CFR 0.152.
 */
package no.nav.common.kafka.producer;

import java.time.Duration;
import java.util.Properties;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GracefulKafkaProducer<K, V>
extends KafkaProducer<K, V> {
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());

    public GracefulKafkaProducer(Properties properties) {
        super(properties);
        Runtime.getRuntime().addShutdownHook(new Thread(this::shutdown));
    }

    private void shutdown() {
        this.log.info("Shutting down kafka producer...");
        try {
            this.close(Duration.ofSeconds(3L));
            this.log.info("Kafka producer was shut down successfully");
        }
        catch (Exception e) {
            this.log.error("Failed to shut down kafka producer gracefully", (Throwable)e);
        }
    }
}

