/*
 * Decompiled with CFR 0.152.
 */
package no.nav.common.kafka.spring;

import java.util.List;
import no.nav.common.kafka.producer.feilhandtering.KafkaProducerRepository;
import no.nav.common.kafka.producer.feilhandtering.StoredProducerRecord;
import no.nav.common.kafka.spring.DatabaseUtils;
import org.springframework.jdbc.core.JdbcTemplate;

public class PostgresJdbcTemplateProducerRepository
implements KafkaProducerRepository {
    private final JdbcTemplate jdbcTemplate;
    private final String producerRecordTable;

    public PostgresJdbcTemplateProducerRepository(JdbcTemplate jdbcTemplate, String producerRecordTableName) {
        this.jdbcTemplate = jdbcTemplate;
        this.producerRecordTable = producerRecordTableName;
    }

    public PostgresJdbcTemplateProducerRepository(JdbcTemplate jdbcTemplate) {
        this(jdbcTemplate, "KAFKA_PRODUCER_RECORD");
    }

    @Override
    public long storeRecord(StoredProducerRecord record) {
        String sql = String.format("INSERT INTO %s (%s, %s, %s, %s, %s) VALUES (?, ?, ?, ?, ?)", this.producerRecordTable, "ID", "TOPIC", "KEY", "VALUE", "HEADERS_JSON");
        long id = DatabaseUtils.incrementAndGetPostgresSequence(this.jdbcTemplate, "KAFKA_PRODUCER_RECORD_ID_SEQ");
        this.jdbcTemplate.update(sql, new Object[]{id, record.getTopic(), record.getKey(), record.getValue(), record.getHeadersJson()});
        return id;
    }

    @Override
    public void deleteRecords(List<Long> ids) {
        String sql = String.format("DELETE FROM %s WHERE %s = ANY(?::bigint[])", this.producerRecordTable, "ID");
        this.jdbcTemplate.update(sql, new Object[]{DatabaseUtils.toPostgresArray(ids)});
    }

    @Override
    public List<StoredProducerRecord> getRecords(int maxMessages) {
        String sql = String.format("SELECT * FROM %s ORDER BY %s LIMIT %d", this.producerRecordTable, "ID", maxMessages);
        return (List)this.jdbcTemplate.query(sql, DatabaseUtils::fetchProducerRecords);
    }

    @Override
    public List<StoredProducerRecord> getRecords(int maxMessages, List<String> topics) {
        String sql = String.format("SELECT * FROM %s WHERE %s = ANY(?::varchar[]) ORDER BY %s LIMIT %d", this.producerRecordTable, "TOPIC", "ID", maxMessages);
        return (List)this.jdbcTemplate.query(sql, DatabaseUtils::fetchProducerRecords, new Object[]{DatabaseUtils.toPostgresArray(topics)});
    }
}

