/*
 * Decompiled with CFR 0.152.
 */
package no.nav.log;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletResponse;
import no.nav.log.LogFilter;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;

public class LogFilterTest {
    private static final Logger LOG = LoggerFactory.getLogger(LogFilterTest.class);
    private MockHttpServletRequest httpServletRequest = new MockHttpServletRequest();
    private HttpServletResponse httpServletResponse = new MockHttpServletResponse();
    private LogFilter logFilter = new LogFilter();

    @Before
    public void setup() {
        this.httpServletRequest.setMethod("GET");
        this.httpServletRequest.setRequestURI("/test/path");
    }

    @Test
    public void smoketest() throws ServletException, IOException {
        this.logFilter.doFilter((ServletRequest)this.httpServletRequest, (ServletResponse)this.httpServletResponse, (request, response) -> LOG.info("testing logging 1"));
        this.logFilter.doFilter((ServletRequest)this.httpServletRequest, (ServletResponse)this.httpServletResponse, (request, response) -> LOG.info("testing logging 2"));
        this.logFilter.doFilter((ServletRequest)this.httpServletRequest, (ServletResponse)this.httpServletResponse, (request, response) -> LOG.info("testing logging 3"));
    }

    @Test
    public void cleanupOfMDCContext() throws ServletException, IOException {
        Map initialContextMap = Optional.ofNullable(MDC.getCopyOfContextMap()).orElseGet(HashMap::new);
        this.logFilter.doFilter((ServletRequest)this.httpServletRequest, (ServletResponse)this.httpServletResponse, (request, response) -> {});
        Assertions.assertThat((Map)initialContextMap).isEqualTo((Object)MDC.getCopyOfContextMap());
    }

    @Test
    public void addResponseHeaders() throws ServletException, IOException {
        this.logFilter.doFilter((ServletRequest)this.httpServletRequest, (ServletResponse)this.httpServletResponse, (request, response) -> {});
        Assertions.assertThat((String)this.httpServletResponse.getHeader("Nav-Call-Id")).isNotEmpty();
        Assertions.assertThat((String)this.httpServletResponse.getHeader("Set-Cookie")).isNotEmpty();
    }

    @Test
    public void handleExceptions() throws ServletException, IOException {
        this.logFilter.doFilter((ServletRequest)this.httpServletRequest, (ServletResponse)this.httpServletResponse, (request, response) -> this.fail());
        Assertions.assertThat((int)this.httpServletResponse.getStatus()).isEqualTo(500);
    }

    private void fail() {
        throw new IllegalStateException();
    }
}

