/*
 * Decompiled with CFR 0.152.
 */
package no.nav.log;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.classic.spi.IThrowableProxy;
import ch.qos.logback.classic.spi.LoggerContextVO;
import java.util.HashMap;
import java.util.Map;
import no.nav.log.MaskedThrowableProxy;
import org.slf4j.Marker;

public class MaskedLoggingEvent
implements ILoggingEvent {
    private final ILoggingEvent iLoggingEvent;

    MaskedLoggingEvent(ILoggingEvent iLoggingEvent) {
        this.iLoggingEvent = iLoggingEvent;
    }

    public static String mask(String string) {
        return string != null ? string.replaceAll("(^|\\W)\\d{11}(?=$|\\W)", "$1***********") : null;
    }

    public String getThreadName() {
        return this.iLoggingEvent.getThreadName();
    }

    public Level getLevel() {
        return this.iLoggingEvent.getLevel();
    }

    public String getMessage() {
        return this.iLoggingEvent.getMessage();
    }

    public Object[] getArgumentArray() {
        return this.iLoggingEvent.getArgumentArray();
    }

    public String getFormattedMessage() {
        return MaskedLoggingEvent.mask(this.iLoggingEvent.getFormattedMessage());
    }

    public String getLoggerName() {
        return this.iLoggingEvent.getLoggerName();
    }

    public LoggerContextVO getLoggerContextVO() {
        return this.iLoggingEvent.getLoggerContextVO();
    }

    public IThrowableProxy getThrowableProxy() {
        return MaskedThrowableProxy.mask(this.iLoggingEvent.getThrowableProxy());
    }

    public StackTraceElement[] getCallerData() {
        return this.iLoggingEvent.getCallerData();
    }

    public boolean hasCallerData() {
        return this.iLoggingEvent.hasCallerData();
    }

    public Marker getMarker() {
        return this.iLoggingEvent.getMarker();
    }

    public Map<String, String> getMDCPropertyMap() {
        return new MaskedMap(this.iLoggingEvent.getMDCPropertyMap());
    }

    public Map<String, String> getMdc() {
        return new MaskedMap(this.iLoggingEvent.getMdc());
    }

    public long getTimeStamp() {
        return this.iLoggingEvent.getTimeStamp();
    }

    public void prepareForDeferredProcessing() {
        this.iLoggingEvent.prepareForDeferredProcessing();
    }

    private static class MaskedMap
    extends HashMap<String, String> {
        private MaskedMap(Map<String, String> map) {
            map.forEach((k, v) -> this.put(k, MaskedLoggingEvent.mask(v)));
        }
    }
}

