/*
 * Decompiled with CFR 0.152.
 */
package no.nav.sbl.util;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.core.ContextBase;
import java.util.List;
import no.nav.log.MarkerBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(LogUtils.class);
    public static final String ROOT = "ROOT";

    public static void setGlobalLogLevel(Level newLevel) {
        LOGGER.info("global log level: {}", (Object)newLevel);
        LoggerContext loggerContext = LogUtils.getLoggerContext();
        loggerContext.getLoggerList().forEach(l -> l.setLevel(newLevel));
    }

    public static void shutDownLogback() {
        LOGGER.info("shutDownLogback");
        LoggerContext loggerContext = LogUtils.getLoggerContext();
        loggerContext.stop();
    }

    private static LoggerContext getLoggerContext() {
        ContextBase contextBase = (ContextBase)LoggerFactory.getILoggerFactory();
        return (LoggerContext)contextBase;
    }

    public static List<ch.qos.logback.classic.Logger> getAllLoggers() {
        LoggerContext loggerContext = LogUtils.getLoggerContext();
        return loggerContext.getLoggerList();
    }

    public static Level getRootLevel() {
        LoggerContext loggerContext = LogUtils.getLoggerContext();
        return loggerContext.getLogger(ROOT).getLevel();
    }

    public static MarkerBuilder buildMarker() {
        return new MarkerBuilder();
    }
}

