/*
 * Decompiled with CFR 0.152.
 */
package no.nav.common.log;

import java.io.IOException;
import java.util.Arrays;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import no.nav.common.log.LogUtils;
import no.nav.common.utils.IdUtils;
import no.nav.common.utils.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public class LogFilter
implements Filter {
    private static final Logger log = LoggerFactory.getLogger(LogFilter.class);
    private static final String LOG_FILTER_FILTERED = "LOG_FILTER_FILTERED";
    public static final String CONSUMER_ID_HEADER_NAME = "Nav-Consumer-Id";
    public static final String PREFERRED_NAV_CALL_ID_HEADER_NAME = "Nav-Call-Id";
    public static final String[] NAV_CALL_ID_HEADER_NAMES = new String[]{"Nav-Call-Id", "Nav-CallId", "X-Correlation-Id"};
    private static final String RANDOM_USER_ID_COOKIE_NAME = "RUIDC";
    private static final int ONE_MONTH_IN_SECONDS = 2592000;
    private final String applicationName;
    private final boolean exposeErrorDetails;

    public LogFilter(String applicationName) {
        this.applicationName = applicationName;
        this.exposeErrorDetails = false;
    }

    public LogFilter(String applicationName, boolean exposeErrorDetails) {
        this.applicationName = applicationName;
        this.exposeErrorDetails = exposeErrorDetails;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        boolean hasAlreadyFilteredAttribute;
        if (!(request instanceof HttpServletRequest) || !(response instanceof HttpServletResponse)) {
            throw new ServletException("LogFilter supports only HTTP requests");
        }
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        boolean bl = hasAlreadyFilteredAttribute = request.getAttribute(LOG_FILTER_FILTERED) != null;
        if (hasAlreadyFilteredAttribute) {
            filterChain.doFilter(request, response);
        } else {
            request.setAttribute(LOG_FILTER_FILTERED, (Object)Boolean.TRUE);
            try {
                this.filter(httpRequest, httpResponse, filterChain);
            }
            finally {
                request.removeAttribute(LOG_FILTER_FILTERED);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void filter(HttpServletRequest httpRequest, HttpServletResponse httpResponse, FilterChain filterChain) throws IOException, ServletException {
        String userId = this.resolveUserId(httpRequest);
        if (StringUtils.nullOrEmpty((String)userId)) {
            this.generateUserIdCookie(httpResponse);
        }
        String consumerId = httpRequest.getHeader(CONSUMER_ID_HEADER_NAME);
        String callId = LogFilter.resolveCallId(httpRequest);
        MDC.put((String)"callId", (String)callId);
        MDC.put((String)"userId", (String)userId);
        MDC.put((String)"consumerId", (String)consumerId);
        MDC.put((String)"requestId", (String)IdUtils.generateId());
        httpResponse.setHeader(PREFERRED_NAV_CALL_ID_HEADER_NAME, callId);
        if (this.applicationName != null) {
            httpResponse.setHeader("Server", this.applicationName);
        }
        try {
            this.filterWithErrorHandling(httpRequest, httpResponse, filterChain);
            LogUtils.buildMarker().field("status", httpResponse.getStatus()).field("method", httpRequest.getMethod()).field("host", httpRequest.getServerName()).field("path", httpRequest.getRequestURI()).log((arg_0, arg_1) -> ((Logger)log).info(arg_0, arg_1));
        }
        finally {
            MDC.remove((String)"callId");
            MDC.remove((String)"userId");
            MDC.remove((String)"consumerId");
            MDC.remove((String)"requestId");
        }
    }

    public static String resolveCallId(HttpServletRequest httpRequest) {
        return Arrays.stream(NAV_CALL_ID_HEADER_NAMES).map(arg_0 -> ((HttpServletRequest)httpRequest).getHeader(arg_0)).filter(StringUtils::notNullOrEmpty).findFirst().orElseGet(IdUtils::generateId);
    }

    private void generateUserIdCookie(HttpServletResponse httpResponse) {
        String userId = IdUtils.generateId();
        Cookie cookie = new Cookie(RANDOM_USER_ID_COOKIE_NAME, userId);
        cookie.setPath("/");
        cookie.setMaxAge(2592000);
        cookie.setHttpOnly(true);
        cookie.setSecure(true);
        httpResponse.addCookie(cookie);
    }

    private void filterWithErrorHandling(HttpServletRequest httpRequest, HttpServletResponse httpResponse, FilterChain filterChain) throws IOException, ServletException {
        block3: {
            try {
                filterChain.doFilter((ServletRequest)httpRequest, (ServletResponse)httpResponse);
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
                if (httpResponse.isCommitted()) {
                    log.error("failed with status={}", (Object)httpResponse.getStatus());
                    throw e;
                }
                httpResponse.setStatus(500);
                if (!this.exposeErrorDetails) break block3;
                e.printStackTrace(httpResponse.getWriter());
            }
        }
    }

    public String resolveUserId(HttpServletRequest httpRequest) {
        Cookie[] cookies = httpRequest.getCookies();
        if (cookies != null) {
            for (Cookie cookie : cookies) {
                if (!RANDOM_USER_ID_COOKIE_NAME.equals(cookie.getName())) continue;
                return cookie.getValue();
            }
        }
        return null;
    }

    public void init(FilterConfig filterConfig) {
    }

    public void destroy() {
    }
}

