/*
 * Decompiled with CFR 0.152.
 */
package no.nav.common.log;

import ch.qos.logback.classic.Level;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicReference;
import no.nav.common.log.LogUtils;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public class LogUtilsTest {
    private static final Logger LOGGER = LoggerFactory.getLogger(LogUtilsTest.class);
    private static final String FNR = "12345678901";

    @Test
    public void smoketest() {
        LogUtils.setGlobalLogLevel((Level)Level.INFO);
        MDC.put((String)LogUtilsTest.class.getName(), (String)FNR);
        LOGGER.info(FNR);
        LOGGER.info("fnr: {}", (Object)FNR);
        LOGGER.info("<tag>{}</tag>", (Object)FNR);
        LOGGER.info("info");
        LOGGER.error(FNR, (Throwable)new RuntimeException(FNR, new IllegalArgumentException(FNR)));
        LogUtils.buildMarker().field("fnr2", (Object)FNR).field("number", (Object)42).field("a", (Object)"b").field("c", null).log((arg_0, arg_1) -> ((Logger)LOGGER).info(arg_0, arg_1));
        LogUtils.buildMarker().log((arg_0, arg_1) -> ((Logger)LOGGER).info(arg_0, arg_1)).field("more", (Object)"stuff").log((arg_0, arg_1) -> ((Logger)LOGGER).error(arg_0, arg_1));
        LogUtils.setGlobalLogLevel((Level)Level.ERROR);
        LOGGER.info("info");
    }

    @Test
    public void runWithMDCContext_skal_legge_til_MDC_variabler() throws InterruptedException {
        MDC.clear();
        MDC.put((String)"TEST", (String)"hello");
        Map contextMap = MDC.getCopyOfContextMap();
        AtomicReference mdcValueRef = new AtomicReference();
        CountDownLatch countDownLatch = new CountDownLatch(1);
        new Thread(() -> LogUtils.runWithMDCContext((Map)contextMap, () -> {
            mdcValueRef.set(MDC.get((String)"TEST"));
            countDownLatch.countDown();
        })).start();
        countDownLatch.await();
        Assert.assertEquals((Object)"hello", mdcValueRef.get());
    }

    @Test
    public void runWithMDCContext_skal_rydde_opp_context() throws InterruptedException {
        MDC.clear();
        Map contextMap = MDC.getCopyOfContextMap();
        AtomicReference mdcValueRef = new AtomicReference();
        CountDownLatch countDownLatch = new CountDownLatch(1);
        new Thread(() -> {
            LogUtils.runWithMDCContext((Map)contextMap, () -> MDC.put((String)"TEST1", (String)"hello1"));
            mdcValueRef.set(MDC.get((String)"TEST1"));
            countDownLatch.countDown();
        }).start();
        countDownLatch.await();
        Assert.assertNull(mdcValueRef.get());
    }
}

