/*
 * Decompiled with CFR 0.152.
 */
package no.nav.common.log;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.core.ContextBase;
import java.util.List;
import java.util.Map;
import no.nav.common.log.MarkerBuilder;
import no.nav.common.utils.fn.UnsafeRunnable;
import no.nav.common.utils.fn.UnsafeSupplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.slf4j.spi.MDCAdapter;

public class LogUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(LogUtils.class);
    public static final String ROOT = "ROOT";

    public static void runWithMDCContext(Map<String, String> mdcContext, UnsafeRunnable runnable) {
        LogUtils.runWithMDCContext(mdcContext, () -> {
            runnable.run();
            return null;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T runWithMDCContext(Map<String, String> mdcContext, UnsafeSupplier<T> supplier) {
        MDCAdapter mdcAdapter = MDC.getMDCAdapter();
        Map prevContext = MDC.getCopyOfContextMap();
        try {
            if (mdcAdapter != null && mdcContext != null) {
                mdcAdapter.setContextMap(mdcContext);
            }
            Object object = supplier.get();
            return (T)object;
        }
        finally {
            if (mdcAdapter != null) {
                if (prevContext != null) {
                    mdcAdapter.setContextMap(prevContext);
                } else {
                    mdcAdapter.clear();
                }
            }
        }
    }

    public static void setGlobalLogLevel(Level newLevel) {
        LOGGER.info("global log level: {}", (Object)newLevel);
        LoggerContext loggerContext = LogUtils.getLoggerContext();
        loggerContext.getLoggerList().forEach(l -> l.setLevel(newLevel));
    }

    public static void shutDownLogback() {
        LOGGER.info("shutDownLogback");
        LoggerContext loggerContext = LogUtils.getLoggerContext();
        loggerContext.stop();
    }

    private static LoggerContext getLoggerContext() {
        ContextBase contextBase = (ContextBase)LoggerFactory.getILoggerFactory();
        return (LoggerContext)contextBase;
    }

    public static List<ch.qos.logback.classic.Logger> getAllLoggers() {
        LoggerContext loggerContext = LogUtils.getLoggerContext();
        return loggerContext.getLoggerList();
    }

    public static Level getRootLevel() {
        LoggerContext loggerContext = LogUtils.getLoggerContext();
        return loggerContext.getLogger(ROOT).getLevel();
    }

    public static MarkerBuilder buildMarker() {
        return new MarkerBuilder();
    }
}

