/*
 * Decompiled with CFR 0.152.
 */
package no.nav.common.log;

import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicReference;
import no.nav.common.log.LogUtils;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.MDC;

public class LogUtilsTest {
    @Test
    public void runWithMDCContext_skal_legge_til_MDC_variabler() throws InterruptedException {
        MDC.clear();
        MDC.put((String)"TEST", (String)"hello");
        Map contextMap = MDC.getCopyOfContextMap();
        AtomicReference mdcValueRef = new AtomicReference();
        CountDownLatch countDownLatch = new CountDownLatch(1);
        new Thread(() -> LogUtils.runWithMDCContext((Map)contextMap, () -> {
            mdcValueRef.set(MDC.get((String)"TEST"));
            countDownLatch.countDown();
        })).start();
        countDownLatch.await();
        Assert.assertEquals((Object)"hello", mdcValueRef.get());
    }

    @Test
    public void runWithMDCContext_skal_rydde_opp_context() throws InterruptedException {
        MDC.clear();
        Map contextMap = MDC.getCopyOfContextMap();
        AtomicReference mdcValueRef = new AtomicReference();
        CountDownLatch countDownLatch = new CountDownLatch(1);
        new Thread(() -> {
            LogUtils.runWithMDCContext((Map)contextMap, () -> MDC.put((String)"TEST1", (String)"hello1"));
            mdcValueRef.set(MDC.get((String)"TEST1"));
            countDownLatch.countDown();
        }).start();
        countDownLatch.await();
        Assert.assertNull(mdcValueRef.get());
    }
}

