/*
 * Decompiled with CFR 0.152.
 */
package no.nav.common.log;

import no.nav.common.log.MaskedLoggingEvent;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MaskedLoggingEventTest {
    private static final Logger LOGGER = LoggerFactory.getLogger(MaskedLoggingEvent.class);
    public static final String MASKED_FNR = "***********";

    @Test
    public void masked() {
        this.assertMasked("-12345678901");
        this.assertMasked("12345678901");
        this.assertMasked(" 12345678901");
        this.assertMasked("12345678901 ");
        this.assertMasked(" 12345678901 ");
        this.assertMasked("abc 12345678901 def");
        this.assertMasked("callId=7b7c<12345676543>c8c32129c837808f7");
    }

    @Test
    public void unmasked() {
        this.assertUnmasked("");
        this.assertUnmasked("abc");
        this.assertUnmasked("1234");
        this.assertUnmasked("1234567890");
        this.assertUnmasked("123456789012");
        this.assertUnmasked("callId=7b7c12345676543c8c32129c837808f7");
    }

    @Test
    public void nullValue() {
        Assertions.assertThat((String)MaskedLoggingEvent.mask(null)).isNull();
    }

    @Test
    public void formatting() {
        this.assertMaskedAS("12345678901-12345678901 12345678901", "***********-*********** ***********");
        this.assertMaskedAS("12345678901,12345678901", "***********,***********");
    }

    private void assertMasked(String string) {
        LOGGER.info(string);
        Assertions.assertThat((String)MaskedLoggingEvent.mask((String)string)).contains(new CharSequence[]{MASKED_FNR});
    }

    private void assertUnmasked(String string) {
        LOGGER.info(string);
        Assertions.assertThat((String)MaskedLoggingEvent.mask((String)string)).doesNotContain(new CharSequence[]{"*"});
    }

    private void assertMaskedAS(String string, String expected) {
        LOGGER.info(string);
        Assertions.assertThat((String)MaskedLoggingEvent.mask((String)string)).isEqualTo((Object)expected);
    }
}

