/*
 * Decompiled with CFR 0.152.
 */
package no.nav.common.log;

import java.util.Map;
import no.nav.common.utils.fn.UnsafeRunnable;
import no.nav.common.utils.fn.UnsafeSupplier;
import org.slf4j.MDC;
import org.slf4j.spi.MDCAdapter;

public class LogUtils {
    public static void runWithMDCContext(Map<String, String> mdcContext, UnsafeRunnable runnable) {
        LogUtils.runWithMDCContext(mdcContext, () -> {
            runnable.run();
            return null;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T runWithMDCContext(Map<String, String> mdcContext, UnsafeSupplier<T> supplier) {
        MDCAdapter mdcAdapter = MDC.getMDCAdapter();
        Map prevContext = MDC.getCopyOfContextMap();
        try {
            if (mdcAdapter != null && mdcContext != null) {
                mdcAdapter.setContextMap(mdcContext);
            }
            Object object = supplier.get();
            return (T)object;
        }
        finally {
            if (mdcAdapter != null) {
                if (prevContext != null) {
                    mdcAdapter.setContextMap(prevContext);
                } else {
                    mdcAdapter.clear();
                }
            }
        }
    }
}

