/*
 * Decompiled with CFR 0.152.
 */
package no.nav.metrics.proxy;

import java.lang.reflect.InvocationHandler;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public abstract class MetricProxy
implements InvocationHandler {
    public static final List<String> DO_NOT_MEASURE_METHOD_NAMES = new ArrayList<String>(Arrays.asList("hashCode", "equals", "toString"));
    private boolean includedMethodsAreDefined = false;
    private boolean excludedMethodsAreDefined = false;
    private List<String> includedMethodNames;
    private List<String> excludedMethodNames;
    final Object object;
    final String name;

    MetricProxy(String name, Object object) {
        this.name = name;
        this.object = object;
    }

    public void includeMethods(List<String> methodNames) {
        if (this.excludedMethodsAreDefined) {
            throw new IllegalStateException("Include and exclude are mutual exclusive methods");
        }
        this.includedMethodNames = new ArrayList<String>(methodNames);
        this.includedMethodsAreDefined = true;
    }

    public void excludeMethods(List<String> methodNames) {
        if (this.includedMethodsAreDefined) {
            throw new IllegalStateException("Include and exclude are mutual exclusive methods");
        }
        this.excludedMethodNames = new ArrayList<String>(methodNames);
        this.excludedMethodsAreDefined = true;
    }

    protected boolean shouldMeasureMethod(String methodName) {
        if (DO_NOT_MEASURE_METHOD_NAMES.contains(methodName)) {
            return false;
        }
        if (this.includedMethodsAreDefined && !this.includedMethodNames.contains(methodName)) {
            return false;
        }
        return !this.excludedMethodsAreDefined || !this.excludedMethodNames.contains(methodName);
    }
}

