/*
 * Decompiled with CFR 0.152.
 */
package no.nav.metrics;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import no.nav.metrics.MetricsClient;
import org.slf4j.MDC;

abstract class Metric<T extends Metric> {
    protected final MetricsClient metricsClient;
    protected final String name;
    protected Map<String, Object> fields = new HashMap<String, Object>();
    protected Map<String, String> tags = new HashMap<String, String>();
    private static final String[] MDC_VARIABLES = new String[]{"callId", "userId", "requestId", "consumerId"};

    Metric(MetricsClient metricsClient, String name) {
        this.metricsClient = metricsClient;
        this.name = name;
        this.setSuccess();
        for (String mdcVariable : MDC_VARIABLES) {
            String mdcValue = MDC.get((String)mdcVariable);
            if (!Objects.nonNull(mdcValue)) continue;
            this.addFieldToReport(mdcVariable, mdcValue);
        }
    }

    public T addFieldToReport(String fieldName, Object value) {
        this.fields.put(fieldName, value);
        return this.self();
    }

    public T addTagToReport(String tagName, String value) {
        this.tags.put(tagName, value);
        return this.self();
    }

    public T setSuccess() {
        this.addFieldToReport("success", true);
        return this.self();
    }

    public T setFailed() {
        this.addFieldToReport("success", false);
        return this.self();
    }

    public abstract T report();

    protected abstract T self();
}

