/*
 * Decompiled with CFR 0.152.
 */
package no.nav.metrics.utils;

import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import no.nav.metrics.MetricsFactory;
import no.nav.metrics.Timer;

public class MetricsUtils {
    public static <S, T> Function<S, T> timed(String navn, Function<S, T> function) {
        return MetricsUtils.timed(navn, function, null);
    }

    public static <S, T> Function<S, T> timed(String navn, Function<S, T> function, BiConsumer<Timer, Boolean> tagsAppender) {
        return s -> {
            boolean hasFailed = false;
            Timer timer = MetricsFactory.createTimer(navn);
            try {
                timer.start();
                Object r = function.apply(s);
                return r;
            }
            catch (Throwable e) {
                hasFailed = true;
                timer.setFailed();
                throw e;
            }
            finally {
                timer.stop();
                if (tagsAppender != null) {
                    tagsAppender.accept(timer, hasFailed);
                }
                timer.report();
            }
        };
    }

    public static <S> S timed(String navn, Supplier<S> supplier) {
        return MetricsUtils.timed(navn, supplier, null);
    }

    public static <S> S timed(String navn, Supplier<S> supplier, BiConsumer<Timer, Boolean> tagsAppender) {
        return MetricsUtils.functionToSupplier(MetricsUtils.timed(navn, MetricsUtils.supplierToFunction(supplier), tagsAppender)).get();
    }

    public static <S> Consumer<S> timed(String navn, Consumer<S> consumer) {
        return MetricsUtils.timed(navn, consumer, null);
    }

    public static <S> Consumer<S> timed(String navn, Consumer<S> consumer, BiConsumer<Timer, Boolean> tagsAppender) {
        return MetricsUtils.functionToConsumer(MetricsUtils.timed(navn, MetricsUtils.consumerToFunction(consumer), tagsAppender));
    }

    public static void timed(String navn, Runnable runnable) {
        MetricsUtils.functionToRunnable(MetricsUtils.timed(navn, MetricsUtils.runnableToFunction(runnable))).run();
    }

    public static void timed(String navn, Runnable runnable, BiConsumer<Timer, Boolean> tagsAppender) {
        MetricsUtils.functionToRunnable(MetricsUtils.timed(navn, MetricsUtils.runnableToFunction(runnable), tagsAppender)).run();
    }

    private static <S> Function<S, Void> consumerToFunction(Consumer<S> consumer) {
        return s -> {
            consumer.accept(s);
            return null;
        };
    }

    private static <S> Consumer<S> functionToConsumer(Function<S, Void> function) {
        return function::apply;
    }

    private static <S> Function<Void, S> supplierToFunction(Supplier<S> supplier) {
        return v -> supplier.get();
    }

    private static <S> Supplier<S> functionToSupplier(Function<Void, S> function) {
        return () -> function.apply(null);
    }

    private static Runnable functionToRunnable(Function<Void, Void> function) {
        return () -> {
            Void cfr_ignored_0 = (Void)function.apply(null);
        };
    }

    private static Function<Void, Void> runnableToFunction(Runnable runnable) {
        return aVoid -> {
            runnable.run();
            return null;
        };
    }
}

