/*
 * Decompiled with CFR 0.152.
 */
package no.nav.metrics.aspects;

import java.util.HashMap;
import java.util.Map;
import no.nav.metrics.MetodeEvent;
import no.nav.metrics.aspects.AspectMetodekall;
import no.nav.metrics.aspects.AspectUtil;
import no.nav.metrics.aspects.Count;
import no.nav.metrics.aspects.Field;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class CountAspect {
    @Pointcut(value="execution(public * *(..))")
    public void publicMethod() {
    }

    @Around(value="publicMethod() && @annotation(count)")
    public Object countPaMetode(ProceedingJoinPoint joinPoint, Count count) throws Throwable {
        AspectMetodekall metodekall = new AspectMetodekall(joinPoint);
        String eventNavn = AspectUtil.lagMetodeTimernavn((JoinPoint)joinPoint, count.name());
        return MetodeEvent.eventForMetode(metodekall, eventNavn, this.finnArgumentVerdier((JoinPoint)joinPoint, count));
    }

    @Around(value="publicMethod() && @within(count)")
    public Object countPaKlasse(ProceedingJoinPoint joinPoint, Count count) throws Throwable {
        if (AspectUtil.metodeSkalIgnoreres(AspectUtil.getMetodenavn((JoinPoint)joinPoint), count.ignoredMethods())) {
            return joinPoint.proceed();
        }
        AspectMetodekall metodekall = new AspectMetodekall(joinPoint);
        String eventNavn = AspectUtil.lagKlasseTimernavn((JoinPoint)joinPoint, count.name());
        return MetodeEvent.eventForMetode(metodekall, eventNavn);
    }

    private Map<String, String> finnArgumentVerdier(JoinPoint joinPoint, Count count) {
        if (count.fields().length == 0) {
            return null;
        }
        HashMap<String, String> verdier = new HashMap<String, String>();
        Object[] args = joinPoint.getArgs();
        for (Field field : count.fields()) {
            String value = args[Integer.parseInt(field.argumentNumber()) - 1].toString();
            verdier.put(field.key(), value);
        }
        return verdier;
    }
}

