/*
 * Decompiled with CFR 0.152.
 */
package no.nav.metrics.aspects;

import no.nav.metrics.MetodeTimer;
import no.nav.metrics.aspects.AspectMetodekall;
import no.nav.metrics.aspects.AspectUtil;
import no.nav.metrics.aspects.Timed;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class TimerAspect {
    @Pointcut(value="execution(public * *(..))")
    public void publicMethod() {
    }

    @Around(value="publicMethod() && @annotation(timed)")
    public Object timerPaMetode(ProceedingJoinPoint joinPoint, Timed timed) throws Throwable {
        AspectMetodekall metodekall = new AspectMetodekall(joinPoint);
        String timerName = AspectUtil.lagMetodeTimernavn((JoinPoint)joinPoint, timed.name());
        return MetodeTimer.timeMetode(metodekall, timerName);
    }

    @Around(value="publicMethod() && @within(timed)")
    public Object timerPaKlasse(ProceedingJoinPoint joinPoint, Timed timed) throws Throwable {
        if (AspectUtil.metodeSkalIgnoreres(AspectUtil.getMetodenavn((JoinPoint)joinPoint), timed.ignoredMethods())) {
            return joinPoint.proceed();
        }
        AspectMetodekall metodekall = new AspectMetodekall(joinPoint);
        String timerNavn = AspectUtil.lagKlasseTimernavn((JoinPoint)joinPoint, timed.name());
        return MetodeTimer.timeMetode(metodekall, timerNavn);
    }
}

