/*
 * Decompiled with CFR 0.152.
 */
package no.nav.metrics;

import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.prometheus.PrometheusConfig;
import io.micrometer.prometheus.PrometheusMeterRegistry;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import no.nav.metrics.Event;
import no.nav.metrics.MetricsClient;
import no.nav.metrics.MetricsConfig;
import no.nav.metrics.Timer;
import no.nav.metrics.proxy.EventProxy;
import no.nav.metrics.proxy.TimerProxy;

public class MetricsFactory {
    private static final MetricsClient metricsClient = new MetricsClient();
    private static final PrometheusMeterRegistry prometheusMeterRegistry = new ProtectedPrometheusMeterRegistry();

    public static void enableMetrics(MetricsConfig metricsConfig) {
        MetricsClient.enableMetrics(metricsConfig);
    }

    public static Timer createTimer(String name) {
        return new Timer(metricsClient, name);
    }

    public static Event createEvent(String name) {
        return new Event(metricsClient, name);
    }

    public static <T> T createTimerProxy(String name, T object, Class<T> type) {
        return MetricsFactory.createTimerProxyInstance(name, object, type);
    }

    public static <T> T createTimerProxyForWebService(String name, T object, Class<T> type) {
        return MetricsFactory.createTimerProxyInstance("ws." + name, object, type);
    }

    private static <T> T createTimerProxyInstance(String name, T object, Class<T> type) {
        ClassLoader classLoader = TimerProxy.class.getClassLoader();
        Class[] classes = new Class[]{type};
        TimerProxy timerProxy = new TimerProxy(name, object);
        return (T)Proxy.newProxyInstance(classLoader, classes, (InvocationHandler)timerProxy);
    }

    public static <T> T createEventProxy(String name, T object, Class<T> type) {
        ClassLoader classLoader = EventProxy.class.getClassLoader();
        Class[] classes = new Class[]{type};
        EventProxy eventProxy = new EventProxy(name, object);
        return (T)Proxy.newProxyInstance(classLoader, classes, (InvocationHandler)eventProxy);
    }

    public static MeterRegistry getMeterRegistry() {
        return prometheusMeterRegistry;
    }

    private static class ProtectedPrometheusMeterRegistry
    extends PrometheusMeterRegistry {
        public ProtectedPrometheusMeterRegistry() {
            super(PrometheusConfig.DEFAULT);
        }

        public void close() {
            throw new UnsupportedOperationException();
        }
    }
}

