/*
 * Decompiled with CFR 0.152.
 */
package no.nav.metrics;

import no.nav.sbl.util.EnvironmentUtils;

public final class MetricsConfig {
    public static final String SENSU_CLIENT_HOST = "sensu_client_host";
    public static final String SENSU_CLIENT_PORT = "sensu_client_port";
    public static final String SENSU_RETRY_INTERVAL_PROPERTY_NAME = "metrics.sensu.report.retryInterval";
    public static final String SENSU_QUEUE_SIZE_PROPERTY_NAME = "metrics.sensu.report.queueSize";
    public static final String SENSU_BATCHES_PER_SECOND_PROPERTY_NAME = "metrics.sensu.report.batchesPerSecond";
    public static final String SENSU_BATCH_SIZE_PROPERTY_NAME = "metrics.sensu.report.batchSize";
    private final String sensuHost;
    private final int sensuPort;
    private final String application;
    private final String hostname;
    private final String environment;
    private final int retryInterval;
    private final int queueSize;
    private final int batchesPerSecond;
    private final int batchSize;

    public static MetricsConfig resolveNaisConfig() {
        return MetricsConfig.defaultConfig("sensu.nais", 3030);
    }

    private static MetricsConfig defaultConfig(String host, int port) {
        return MetricsConfig.withSensuDefaults(MetricsConfig.builder().sensuHost(EnvironmentUtils.getOptionalProperty((String)SENSU_CLIENT_HOST, (String[])new String[0]).orElse(host)).sensuPort(EnvironmentUtils.getOptionalProperty((String)SENSU_CLIENT_PORT, (String[])new String[0]).map(Integer::parseInt).orElse(port)).application(EnvironmentUtils.requireApplicationName()).environment(EnvironmentUtils.getEnvironmentName().orElse(EnvironmentUtils.requireNamespace())).hostname(EnvironmentUtils.resolveHostName()).build());
    }

    public static MetricsConfig withSensuDefaults(MetricsConfig metricsConfig) {
        return metricsConfig.withRetryInterval(MetricsConfig.defaultIntSystemProperty(SENSU_RETRY_INTERVAL_PROPERTY_NAME, 1000)).withQueueSize(MetricsConfig.defaultIntSystemProperty(SENSU_QUEUE_SIZE_PROPERTY_NAME, 20000)).withBatchesPerSecond(MetricsConfig.defaultIntSystemProperty(SENSU_BATCHES_PER_SECOND_PROPERTY_NAME, 50)).withBatchSize(MetricsConfig.defaultIntSystemProperty(SENSU_BATCH_SIZE_PROPERTY_NAME, 100));
    }

    private static int defaultIntSystemProperty(String propertyName, int defaultValue) {
        return Integer.parseInt(System.getProperty(propertyName, Integer.toString(defaultValue)));
    }

    MetricsConfig(String sensuHost, int sensuPort, String application, String hostname, String environment, int retryInterval, int queueSize, int batchesPerSecond, int batchSize) {
        this.sensuHost = sensuHost;
        this.sensuPort = sensuPort;
        this.application = application;
        this.hostname = hostname;
        this.environment = environment;
        this.retryInterval = retryInterval;
        this.queueSize = queueSize;
        this.batchesPerSecond = batchesPerSecond;
        this.batchSize = batchSize;
    }

    public static MetricsConfigBuilder builder() {
        return new MetricsConfigBuilder();
    }

    public String getSensuHost() {
        return this.sensuHost;
    }

    public int getSensuPort() {
        return this.sensuPort;
    }

    public String getApplication() {
        return this.application;
    }

    public String getHostname() {
        return this.hostname;
    }

    public String getEnvironment() {
        return this.environment;
    }

    public int getRetryInterval() {
        return this.retryInterval;
    }

    public int getQueueSize() {
        return this.queueSize;
    }

    public int getBatchesPerSecond() {
        return this.batchesPerSecond;
    }

    public int getBatchSize() {
        return this.batchSize;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MetricsConfig)) {
            return false;
        }
        MetricsConfig other = (MetricsConfig)o;
        String this$sensuHost = this.getSensuHost();
        String other$sensuHost = other.getSensuHost();
        if (this$sensuHost == null ? other$sensuHost != null : !this$sensuHost.equals(other$sensuHost)) {
            return false;
        }
        if (this.getSensuPort() != other.getSensuPort()) {
            return false;
        }
        String this$application = this.getApplication();
        String other$application = other.getApplication();
        if (this$application == null ? other$application != null : !this$application.equals(other$application)) {
            return false;
        }
        String this$hostname = this.getHostname();
        String other$hostname = other.getHostname();
        if (this$hostname == null ? other$hostname != null : !this$hostname.equals(other$hostname)) {
            return false;
        }
        String this$environment = this.getEnvironment();
        String other$environment = other.getEnvironment();
        if (this$environment == null ? other$environment != null : !this$environment.equals(other$environment)) {
            return false;
        }
        if (this.getRetryInterval() != other.getRetryInterval()) {
            return false;
        }
        if (this.getQueueSize() != other.getQueueSize()) {
            return false;
        }
        if (this.getBatchesPerSecond() != other.getBatchesPerSecond()) {
            return false;
        }
        return this.getBatchSize() == other.getBatchSize();
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $sensuHost = this.getSensuHost();
        result = result * 59 + ($sensuHost == null ? 43 : $sensuHost.hashCode());
        result = result * 59 + this.getSensuPort();
        String $application = this.getApplication();
        result = result * 59 + ($application == null ? 43 : $application.hashCode());
        String $hostname = this.getHostname();
        result = result * 59 + ($hostname == null ? 43 : $hostname.hashCode());
        String $environment = this.getEnvironment();
        result = result * 59 + ($environment == null ? 43 : $environment.hashCode());
        result = result * 59 + this.getRetryInterval();
        result = result * 59 + this.getQueueSize();
        result = result * 59 + this.getBatchesPerSecond();
        result = result * 59 + this.getBatchSize();
        return result;
    }

    public String toString() {
        return "MetricsConfig(sensuHost=" + this.getSensuHost() + ", sensuPort=" + this.getSensuPort() + ", application=" + this.getApplication() + ", hostname=" + this.getHostname() + ", environment=" + this.getEnvironment() + ", retryInterval=" + this.getRetryInterval() + ", queueSize=" + this.getQueueSize() + ", batchesPerSecond=" + this.getBatchesPerSecond() + ", batchSize=" + this.getBatchSize() + ")";
    }

    public MetricsConfig withSensuHost(String sensuHost) {
        return this.sensuHost == sensuHost ? this : new MetricsConfig(sensuHost, this.sensuPort, this.application, this.hostname, this.environment, this.retryInterval, this.queueSize, this.batchesPerSecond, this.batchSize);
    }

    public MetricsConfig withSensuPort(int sensuPort) {
        return this.sensuPort == sensuPort ? this : new MetricsConfig(this.sensuHost, sensuPort, this.application, this.hostname, this.environment, this.retryInterval, this.queueSize, this.batchesPerSecond, this.batchSize);
    }

    public MetricsConfig withApplication(String application) {
        return this.application == application ? this : new MetricsConfig(this.sensuHost, this.sensuPort, application, this.hostname, this.environment, this.retryInterval, this.queueSize, this.batchesPerSecond, this.batchSize);
    }

    public MetricsConfig withHostname(String hostname) {
        return this.hostname == hostname ? this : new MetricsConfig(this.sensuHost, this.sensuPort, this.application, hostname, this.environment, this.retryInterval, this.queueSize, this.batchesPerSecond, this.batchSize);
    }

    public MetricsConfig withEnvironment(String environment) {
        return this.environment == environment ? this : new MetricsConfig(this.sensuHost, this.sensuPort, this.application, this.hostname, environment, this.retryInterval, this.queueSize, this.batchesPerSecond, this.batchSize);
    }

    public MetricsConfig withRetryInterval(int retryInterval) {
        return this.retryInterval == retryInterval ? this : new MetricsConfig(this.sensuHost, this.sensuPort, this.application, this.hostname, this.environment, retryInterval, this.queueSize, this.batchesPerSecond, this.batchSize);
    }

    public MetricsConfig withQueueSize(int queueSize) {
        return this.queueSize == queueSize ? this : new MetricsConfig(this.sensuHost, this.sensuPort, this.application, this.hostname, this.environment, this.retryInterval, queueSize, this.batchesPerSecond, this.batchSize);
    }

    public MetricsConfig withBatchesPerSecond(int batchesPerSecond) {
        return this.batchesPerSecond == batchesPerSecond ? this : new MetricsConfig(this.sensuHost, this.sensuPort, this.application, this.hostname, this.environment, this.retryInterval, this.queueSize, batchesPerSecond, this.batchSize);
    }

    public MetricsConfig withBatchSize(int batchSize) {
        return this.batchSize == batchSize ? this : new MetricsConfig(this.sensuHost, this.sensuPort, this.application, this.hostname, this.environment, this.retryInterval, this.queueSize, this.batchesPerSecond, batchSize);
    }

    public static class MetricsConfigBuilder {
        private String sensuHost;
        private int sensuPort;
        private String application;
        private String hostname;
        private String environment;
        private int retryInterval;
        private int queueSize;
        private int batchesPerSecond;
        private int batchSize;

        MetricsConfigBuilder() {
        }

        public MetricsConfigBuilder sensuHost(String sensuHost) {
            this.sensuHost = sensuHost;
            return this;
        }

        public MetricsConfigBuilder sensuPort(int sensuPort) {
            this.sensuPort = sensuPort;
            return this;
        }

        public MetricsConfigBuilder application(String application) {
            this.application = application;
            return this;
        }

        public MetricsConfigBuilder hostname(String hostname) {
            this.hostname = hostname;
            return this;
        }

        public MetricsConfigBuilder environment(String environment) {
            this.environment = environment;
            return this;
        }

        public MetricsConfigBuilder retryInterval(int retryInterval) {
            this.retryInterval = retryInterval;
            return this;
        }

        public MetricsConfigBuilder queueSize(int queueSize) {
            this.queueSize = queueSize;
            return this;
        }

        public MetricsConfigBuilder batchesPerSecond(int batchesPerSecond) {
            this.batchesPerSecond = batchesPerSecond;
            return this;
        }

        public MetricsConfigBuilder batchSize(int batchSize) {
            this.batchSize = batchSize;
            return this;
        }

        public MetricsConfig build() {
            return new MetricsConfig(this.sensuHost, this.sensuPort, this.application, this.hostname, this.environment, this.retryInterval, this.queueSize, this.batchesPerSecond, this.batchSize);
        }

        public String toString() {
            return "MetricsConfig.MetricsConfigBuilder(sensuHost=" + this.sensuHost + ", sensuPort=" + this.sensuPort + ", application=" + this.application + ", hostname=" + this.hostname + ", environment=" + this.environment + ", retryInterval=" + this.retryInterval + ", queueSize=" + this.queueSize + ", batchesPerSecond=" + this.batchesPerSecond + ", batchSize=" + this.batchSize + ")";
        }
    }
}

