/*
 * Decompiled with CFR 0.152.
 */
package no.nav.common.metrics;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.ArrayList;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import no.nav.common.metrics.SensuConfig;
import org.apache.commons.lang3.StringUtils;
import org.json.JSONArray;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SensuHandler {
    private static final Logger logger = LoggerFactory.getLogger(SensuHandler.class);
    private final LinkedBlockingQueue<String> reportQueue;
    private final String application;
    private final int sensuPort;
    private final String sensuHost;
    private final ScheduledExecutorService scheduledExecutorService;
    private final int batchSize;
    private final int retryInterval;
    private final int batchDelay;
    private long queueSisteGangFullTimestamp = 0L;

    public SensuHandler(SensuConfig sensuConfig) {
        this.application = sensuConfig.getApplication();
        this.sensuHost = sensuConfig.getSensuHost();
        this.sensuPort = sensuConfig.getSensuPort();
        this.reportQueue = new LinkedBlockingQueue(sensuConfig.getQueueSize());
        this.batchDelay = 1000 / sensuConfig.getBatchesPerSecond();
        this.batchSize = sensuConfig.getBatchSize();
        this.retryInterval = sensuConfig.getRetryInterval();
        this.scheduledExecutorService = Executors.newSingleThreadScheduledExecutor();
        this.scheduledExecutorService.execute(new SensuReporter());
        logger.info("Metrics aktivert med parametre: {}", (Object)sensuConfig);
    }

    public void shutdown() {
        this.scheduledExecutorService.shutdown();
    }

    void writeToSensu(JSONObject jsonObject, Socket socket) throws IOException {
        BufferedWriter writer = this.connectToSensu(socket);
        writer.write(jsonObject.toString());
        writer.newLine();
        writer.flush();
    }

    private BufferedWriter connectToSensu(Socket socket) throws IOException {
        InetSocketAddress inetSocketAddress = new InetSocketAddress(this.sensuHost, this.sensuPort);
        socket.connect(inetSocketAddress, 500);
        return new BufferedWriter(new OutputStreamWriter(socket.getOutputStream()));
    }

    public void report(String output) {
        boolean result = this.reportQueue.offer(output);
        if (!result && System.currentTimeMillis() - this.queueSisteGangFullTimestamp > 60000L) {
            logger.warn("Sensu-k\u00f8en har v\u00e6rt full, ikke alle metrikker har blitt sendt til Sensu.");
            this.queueSisteGangFullTimestamp = System.currentTimeMillis();
        }
    }

    private JSONObject createJSON(String output) {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("name", (Object)this.application);
        jsonObject.put("type", (Object)"metric");
        jsonObject.put("output", (Object)output);
        jsonObject.put("status", 0);
        jsonObject.put("handlers", (Object)new JSONArray("[events_nano]"));
        return jsonObject;
    }

    private class SensuReporter
    implements Runnable {
        private SensuReporter() {
        }

        @Override
        public void run() {
            ArrayList<String> reports = new ArrayList<String>();
            while (true) {
                try {
                    while (true) {
                        String report = SensuHandler.this.reportQueue.take();
                        reports.clear();
                        reports.add(report);
                        SensuHandler.this.reportQueue.drainTo(reports, SensuHandler.this.batchSize - 1);
                        logger.debug("Sender {} metrikker", (Object)reports.size());
                        String influxOutput = StringUtils.join(reports, (String)"\n");
                        JSONObject jsonObject = SensuHandler.this.createJSON(influxOutput);
                        try (Socket socket = new Socket();){
                            SensuHandler.this.writeToSensu(jsonObject, socket);
                        }
                        catch (IOException e) {
                            SensuHandler.this.reportQueue.addAll(reports);
                            logger.error("Noe gikk feil med tilkoblingen til Sensu socket: {} - {}", (Object)e.getClass().getSimpleName(), (Object)e.getMessage());
                            Thread.sleep(SensuHandler.this.retryInterval);
                        }
                        Thread.sleep(SensuHandler.this.batchDelay);
                    }
                }
                catch (InterruptedException e) {
                    logger.error("\u00c5 vente p\u00e5 neste objekt ble avbrutt, b\u00f8r ikke kunne skje.", (Throwable)e);
                    continue;
                }
                break;
            }
        }
    }
}

