/*
 * Decompiled with CFR 0.152.
 */
package no.nav.common.metrics;

import no.nav.common.utils.EnvironmentUtils;

public final class SensuConfig {
    public static final String SENSU_CLIENT_HOST = "sensu_client_host";
    public static final String SENSU_CLIENT_PORT = "sensu_client_port";
    public static final String SENSU_RETRY_INTERVAL_PROPERTY_NAME = "metrics.sensu.report.retryInterval";
    public static final String SENSU_QUEUE_SIZE_PROPERTY_NAME = "metrics.sensu.report.queueSize";
    public static final String SENSU_BATCHES_PER_SECOND_PROPERTY_NAME = "metrics.sensu.report.batchesPerSecond";
    public static final String SENSU_BATCH_SIZE_PROPERTY_NAME = "metrics.sensu.report.batchSize";
    private final String sensuHost;
    private final int sensuPort;
    private final String application;
    private final String hostname;
    private final String cluster;
    private final String namespace;
    private final int retryInterval;
    private final int queueSize;
    private final int batchesPerSecond;
    private final int batchSize;

    public static SensuConfig resolveNaisConfig() {
        return SensuConfig.defaultConfig("sensu.nais", 3030);
    }

    private static SensuConfig defaultConfig(String host, int port) {
        return SensuConfig.withSensuDefaults(SensuConfig.builder().sensuHost(EnvironmentUtils.getOptionalProperty((String)SENSU_CLIENT_HOST, (String[])new String[0]).orElse(host)).sensuPort(EnvironmentUtils.getOptionalProperty((String)SENSU_CLIENT_PORT, (String[])new String[0]).map(Integer::parseInt).orElse(port)).application(EnvironmentUtils.requireApplicationName()).cluster(EnvironmentUtils.requireClusterName()).namespace(EnvironmentUtils.requireNamespace()).hostname(EnvironmentUtils.resolveHostName()).build());
    }

    public static SensuConfig withSensuDefaults(SensuConfig sensuConfig) {
        return sensuConfig.withRetryInterval(SensuConfig.defaultIntSystemProperty(SENSU_RETRY_INTERVAL_PROPERTY_NAME, 1000)).withQueueSize(SensuConfig.defaultIntSystemProperty(SENSU_QUEUE_SIZE_PROPERTY_NAME, 20000)).withBatchesPerSecond(SensuConfig.defaultIntSystemProperty(SENSU_BATCHES_PER_SECOND_PROPERTY_NAME, 50)).withBatchSize(SensuConfig.defaultIntSystemProperty(SENSU_BATCH_SIZE_PROPERTY_NAME, 100));
    }

    private static int defaultIntSystemProperty(String propertyName, int defaultValue) {
        return Integer.parseInt(System.getProperty(propertyName, Integer.toString(defaultValue)));
    }

    SensuConfig(String sensuHost, int sensuPort, String application, String hostname, String cluster, String namespace, int retryInterval, int queueSize, int batchesPerSecond, int batchSize) {
        this.sensuHost = sensuHost;
        this.sensuPort = sensuPort;
        this.application = application;
        this.hostname = hostname;
        this.cluster = cluster;
        this.namespace = namespace;
        this.retryInterval = retryInterval;
        this.queueSize = queueSize;
        this.batchesPerSecond = batchesPerSecond;
        this.batchSize = batchSize;
    }

    public static SensuConfigBuilder builder() {
        return new SensuConfigBuilder();
    }

    public String getSensuHost() {
        return this.sensuHost;
    }

    public int getSensuPort() {
        return this.sensuPort;
    }

    public String getApplication() {
        return this.application;
    }

    public String getHostname() {
        return this.hostname;
    }

    public String getCluster() {
        return this.cluster;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public int getRetryInterval() {
        return this.retryInterval;
    }

    public int getQueueSize() {
        return this.queueSize;
    }

    public int getBatchesPerSecond() {
        return this.batchesPerSecond;
    }

    public int getBatchSize() {
        return this.batchSize;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SensuConfig)) {
            return false;
        }
        SensuConfig other = (SensuConfig)o;
        String this$sensuHost = this.getSensuHost();
        String other$sensuHost = other.getSensuHost();
        if (this$sensuHost == null ? other$sensuHost != null : !this$sensuHost.equals(other$sensuHost)) {
            return false;
        }
        if (this.getSensuPort() != other.getSensuPort()) {
            return false;
        }
        String this$application = this.getApplication();
        String other$application = other.getApplication();
        if (this$application == null ? other$application != null : !this$application.equals(other$application)) {
            return false;
        }
        String this$hostname = this.getHostname();
        String other$hostname = other.getHostname();
        if (this$hostname == null ? other$hostname != null : !this$hostname.equals(other$hostname)) {
            return false;
        }
        String this$cluster = this.getCluster();
        String other$cluster = other.getCluster();
        if (this$cluster == null ? other$cluster != null : !this$cluster.equals(other$cluster)) {
            return false;
        }
        String this$namespace = this.getNamespace();
        String other$namespace = other.getNamespace();
        if (this$namespace == null ? other$namespace != null : !this$namespace.equals(other$namespace)) {
            return false;
        }
        if (this.getRetryInterval() != other.getRetryInterval()) {
            return false;
        }
        if (this.getQueueSize() != other.getQueueSize()) {
            return false;
        }
        if (this.getBatchesPerSecond() != other.getBatchesPerSecond()) {
            return false;
        }
        return this.getBatchSize() == other.getBatchSize();
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $sensuHost = this.getSensuHost();
        result = result * 59 + ($sensuHost == null ? 43 : $sensuHost.hashCode());
        result = result * 59 + this.getSensuPort();
        String $application = this.getApplication();
        result = result * 59 + ($application == null ? 43 : $application.hashCode());
        String $hostname = this.getHostname();
        result = result * 59 + ($hostname == null ? 43 : $hostname.hashCode());
        String $cluster = this.getCluster();
        result = result * 59 + ($cluster == null ? 43 : $cluster.hashCode());
        String $namespace = this.getNamespace();
        result = result * 59 + ($namespace == null ? 43 : $namespace.hashCode());
        result = result * 59 + this.getRetryInterval();
        result = result * 59 + this.getQueueSize();
        result = result * 59 + this.getBatchesPerSecond();
        result = result * 59 + this.getBatchSize();
        return result;
    }

    public String toString() {
        return "SensuConfig(sensuHost=" + this.getSensuHost() + ", sensuPort=" + this.getSensuPort() + ", application=" + this.getApplication() + ", hostname=" + this.getHostname() + ", cluster=" + this.getCluster() + ", namespace=" + this.getNamespace() + ", retryInterval=" + this.getRetryInterval() + ", queueSize=" + this.getQueueSize() + ", batchesPerSecond=" + this.getBatchesPerSecond() + ", batchSize=" + this.getBatchSize() + ")";
    }

    public SensuConfig withSensuHost(String sensuHost) {
        return this.sensuHost == sensuHost ? this : new SensuConfig(sensuHost, this.sensuPort, this.application, this.hostname, this.cluster, this.namespace, this.retryInterval, this.queueSize, this.batchesPerSecond, this.batchSize);
    }

    public SensuConfig withSensuPort(int sensuPort) {
        return this.sensuPort == sensuPort ? this : new SensuConfig(this.sensuHost, sensuPort, this.application, this.hostname, this.cluster, this.namespace, this.retryInterval, this.queueSize, this.batchesPerSecond, this.batchSize);
    }

    public SensuConfig withApplication(String application) {
        return this.application == application ? this : new SensuConfig(this.sensuHost, this.sensuPort, application, this.hostname, this.cluster, this.namespace, this.retryInterval, this.queueSize, this.batchesPerSecond, this.batchSize);
    }

    public SensuConfig withHostname(String hostname) {
        return this.hostname == hostname ? this : new SensuConfig(this.sensuHost, this.sensuPort, this.application, hostname, this.cluster, this.namespace, this.retryInterval, this.queueSize, this.batchesPerSecond, this.batchSize);
    }

    public SensuConfig withCluster(String cluster) {
        return this.cluster == cluster ? this : new SensuConfig(this.sensuHost, this.sensuPort, this.application, this.hostname, cluster, this.namespace, this.retryInterval, this.queueSize, this.batchesPerSecond, this.batchSize);
    }

    public SensuConfig withNamespace(String namespace) {
        return this.namespace == namespace ? this : new SensuConfig(this.sensuHost, this.sensuPort, this.application, this.hostname, this.cluster, namespace, this.retryInterval, this.queueSize, this.batchesPerSecond, this.batchSize);
    }

    public SensuConfig withRetryInterval(int retryInterval) {
        return this.retryInterval == retryInterval ? this : new SensuConfig(this.sensuHost, this.sensuPort, this.application, this.hostname, this.cluster, this.namespace, retryInterval, this.queueSize, this.batchesPerSecond, this.batchSize);
    }

    public SensuConfig withQueueSize(int queueSize) {
        return this.queueSize == queueSize ? this : new SensuConfig(this.sensuHost, this.sensuPort, this.application, this.hostname, this.cluster, this.namespace, this.retryInterval, queueSize, this.batchesPerSecond, this.batchSize);
    }

    public SensuConfig withBatchesPerSecond(int batchesPerSecond) {
        return this.batchesPerSecond == batchesPerSecond ? this : new SensuConfig(this.sensuHost, this.sensuPort, this.application, this.hostname, this.cluster, this.namespace, this.retryInterval, this.queueSize, batchesPerSecond, this.batchSize);
    }

    public SensuConfig withBatchSize(int batchSize) {
        return this.batchSize == batchSize ? this : new SensuConfig(this.sensuHost, this.sensuPort, this.application, this.hostname, this.cluster, this.namespace, this.retryInterval, this.queueSize, this.batchesPerSecond, batchSize);
    }

    public static class SensuConfigBuilder {
        private String sensuHost;
        private int sensuPort;
        private String application;
        private String hostname;
        private String cluster;
        private String namespace;
        private int retryInterval;
        private int queueSize;
        private int batchesPerSecond;
        private int batchSize;

        SensuConfigBuilder() {
        }

        public SensuConfigBuilder sensuHost(String sensuHost) {
            this.sensuHost = sensuHost;
            return this;
        }

        public SensuConfigBuilder sensuPort(int sensuPort) {
            this.sensuPort = sensuPort;
            return this;
        }

        public SensuConfigBuilder application(String application) {
            this.application = application;
            return this;
        }

        public SensuConfigBuilder hostname(String hostname) {
            this.hostname = hostname;
            return this;
        }

        public SensuConfigBuilder cluster(String cluster) {
            this.cluster = cluster;
            return this;
        }

        public SensuConfigBuilder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public SensuConfigBuilder retryInterval(int retryInterval) {
            this.retryInterval = retryInterval;
            return this;
        }

        public SensuConfigBuilder queueSize(int queueSize) {
            this.queueSize = queueSize;
            return this;
        }

        public SensuConfigBuilder batchesPerSecond(int batchesPerSecond) {
            this.batchesPerSecond = batchesPerSecond;
            return this;
        }

        public SensuConfigBuilder batchSize(int batchSize) {
            this.batchSize = batchSize;
            return this;
        }

        public SensuConfig build() {
            return new SensuConfig(this.sensuHost, this.sensuPort, this.application, this.hostname, this.cluster, this.namespace, this.retryInterval, this.queueSize, this.batchesPerSecond, this.batchSize);
        }

        public String toString() {
            return "SensuConfig.SensuConfigBuilder(sensuHost=" + this.sensuHost + ", sensuPort=" + this.sensuPort + ", application=" + this.application + ", hostname=" + this.hostname + ", cluster=" + this.cluster + ", namespace=" + this.namespace + ", retryInterval=" + this.retryInterval + ", queueSize=" + this.queueSize + ", batchesPerSecond=" + this.batchesPerSecond + ", batchSize=" + this.batchSize + ")";
        }
    }
}

