/*
 * Decompiled with CFR 0.152.
 */
package no.nav.common.metrics;

import no.nav.common.utils.EnvironmentUtils;

public final class SensuConfig {
    public static final long DEFAULT_SENSU_RETRY_INTERVAL = 5000L;
    public static final int DEFAULT_SENSU_CONNECT_TIMEOUT = 3000;
    public static final int DEFAULT_SENSU_QUEUE_SIZE = 20000;
    public static final long DEFAULT_SENSU_MAX_BATCH_TIME = 10000L;
    public static final int DEFAULT_SENSU_BATCH_SIZE = 500;
    public static final boolean DEFAULT_SENSU_CLEANUP_ON_SHUTDOWN = true;
    public static final long SENSU_MIN_BATCH_TIME = 100L;
    public static final long SENSU_MIN_QUEUE_SIZE = 100L;
    private final String sensuHost;
    private final int sensuPort;
    private final String application;
    private final String hostname;
    private final String cluster;
    private final String namespace;
    private final long retryInterval;
    private final int connectTimeout;
    private final int queueSize;
    private final long maxBatchTime;
    private final int batchSize;
    private final boolean cleanupOnShutdown;

    public static SensuConfig defaultConfig() {
        return SensuConfig.builder().sensuHost("sensu.nais").sensuPort(3030).application(EnvironmentUtils.requireApplicationName()).hostname(EnvironmentUtils.resolveHostName()).cluster(EnvironmentUtils.requireClusterName()).namespace(EnvironmentUtils.requireNamespace()).retryInterval(5000L).connectTimeout(3000).queueSize(20000).maxBatchTime(10000L).batchSize(500).cleanupOnShutdown(true).build();
    }

    SensuConfig(String sensuHost, int sensuPort, String application, String hostname, String cluster, String namespace, long retryInterval, int connectTimeout, int queueSize, long maxBatchTime, int batchSize, boolean cleanupOnShutdown) {
        this.sensuHost = sensuHost;
        this.sensuPort = sensuPort;
        this.application = application;
        this.hostname = hostname;
        this.cluster = cluster;
        this.namespace = namespace;
        this.retryInterval = retryInterval;
        this.connectTimeout = connectTimeout;
        this.queueSize = queueSize;
        this.maxBatchTime = maxBatchTime;
        this.batchSize = batchSize;
        this.cleanupOnShutdown = cleanupOnShutdown;
    }

    public static SensuConfigBuilder builder() {
        return new SensuConfigBuilder();
    }

    public String getSensuHost() {
        return this.sensuHost;
    }

    public int getSensuPort() {
        return this.sensuPort;
    }

    public String getApplication() {
        return this.application;
    }

    public String getHostname() {
        return this.hostname;
    }

    public String getCluster() {
        return this.cluster;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public long getRetryInterval() {
        return this.retryInterval;
    }

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    public int getQueueSize() {
        return this.queueSize;
    }

    public long getMaxBatchTime() {
        return this.maxBatchTime;
    }

    public int getBatchSize() {
        return this.batchSize;
    }

    public boolean isCleanupOnShutdown() {
        return this.cleanupOnShutdown;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SensuConfig)) {
            return false;
        }
        SensuConfig other = (SensuConfig)o;
        String this$sensuHost = this.getSensuHost();
        String other$sensuHost = other.getSensuHost();
        if (this$sensuHost == null ? other$sensuHost != null : !this$sensuHost.equals(other$sensuHost)) {
            return false;
        }
        if (this.getSensuPort() != other.getSensuPort()) {
            return false;
        }
        String this$application = this.getApplication();
        String other$application = other.getApplication();
        if (this$application == null ? other$application != null : !this$application.equals(other$application)) {
            return false;
        }
        String this$hostname = this.getHostname();
        String other$hostname = other.getHostname();
        if (this$hostname == null ? other$hostname != null : !this$hostname.equals(other$hostname)) {
            return false;
        }
        String this$cluster = this.getCluster();
        String other$cluster = other.getCluster();
        if (this$cluster == null ? other$cluster != null : !this$cluster.equals(other$cluster)) {
            return false;
        }
        String this$namespace = this.getNamespace();
        String other$namespace = other.getNamespace();
        if (this$namespace == null ? other$namespace != null : !this$namespace.equals(other$namespace)) {
            return false;
        }
        if (this.getRetryInterval() != other.getRetryInterval()) {
            return false;
        }
        if (this.getConnectTimeout() != other.getConnectTimeout()) {
            return false;
        }
        if (this.getQueueSize() != other.getQueueSize()) {
            return false;
        }
        if (this.getMaxBatchTime() != other.getMaxBatchTime()) {
            return false;
        }
        if (this.getBatchSize() != other.getBatchSize()) {
            return false;
        }
        return this.isCleanupOnShutdown() == other.isCleanupOnShutdown();
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $sensuHost = this.getSensuHost();
        result = result * 59 + ($sensuHost == null ? 43 : $sensuHost.hashCode());
        result = result * 59 + this.getSensuPort();
        String $application = this.getApplication();
        result = result * 59 + ($application == null ? 43 : $application.hashCode());
        String $hostname = this.getHostname();
        result = result * 59 + ($hostname == null ? 43 : $hostname.hashCode());
        String $cluster = this.getCluster();
        result = result * 59 + ($cluster == null ? 43 : $cluster.hashCode());
        String $namespace = this.getNamespace();
        result = result * 59 + ($namespace == null ? 43 : $namespace.hashCode());
        long $retryInterval = this.getRetryInterval();
        result = result * 59 + (int)($retryInterval >>> 32 ^ $retryInterval);
        result = result * 59 + this.getConnectTimeout();
        result = result * 59 + this.getQueueSize();
        long $maxBatchTime = this.getMaxBatchTime();
        result = result * 59 + (int)($maxBatchTime >>> 32 ^ $maxBatchTime);
        result = result * 59 + this.getBatchSize();
        result = result * 59 + (this.isCleanupOnShutdown() ? 79 : 97);
        return result;
    }

    public String toString() {
        return "SensuConfig(sensuHost=" + this.getSensuHost() + ", sensuPort=" + this.getSensuPort() + ", application=" + this.getApplication() + ", hostname=" + this.getHostname() + ", cluster=" + this.getCluster() + ", namespace=" + this.getNamespace() + ", retryInterval=" + this.getRetryInterval() + ", connectTimeout=" + this.getConnectTimeout() + ", queueSize=" + this.getQueueSize() + ", maxBatchTime=" + this.getMaxBatchTime() + ", batchSize=" + this.getBatchSize() + ", cleanupOnShutdown=" + this.isCleanupOnShutdown() + ")";
    }

    public SensuConfig withSensuHost(String sensuHost) {
        return this.sensuHost == sensuHost ? this : new SensuConfig(sensuHost, this.sensuPort, this.application, this.hostname, this.cluster, this.namespace, this.retryInterval, this.connectTimeout, this.queueSize, this.maxBatchTime, this.batchSize, this.cleanupOnShutdown);
    }

    public SensuConfig withSensuPort(int sensuPort) {
        return this.sensuPort == sensuPort ? this : new SensuConfig(this.sensuHost, sensuPort, this.application, this.hostname, this.cluster, this.namespace, this.retryInterval, this.connectTimeout, this.queueSize, this.maxBatchTime, this.batchSize, this.cleanupOnShutdown);
    }

    public SensuConfig withApplication(String application) {
        return this.application == application ? this : new SensuConfig(this.sensuHost, this.sensuPort, application, this.hostname, this.cluster, this.namespace, this.retryInterval, this.connectTimeout, this.queueSize, this.maxBatchTime, this.batchSize, this.cleanupOnShutdown);
    }

    public SensuConfig withHostname(String hostname) {
        return this.hostname == hostname ? this : new SensuConfig(this.sensuHost, this.sensuPort, this.application, hostname, this.cluster, this.namespace, this.retryInterval, this.connectTimeout, this.queueSize, this.maxBatchTime, this.batchSize, this.cleanupOnShutdown);
    }

    public SensuConfig withCluster(String cluster) {
        return this.cluster == cluster ? this : new SensuConfig(this.sensuHost, this.sensuPort, this.application, this.hostname, cluster, this.namespace, this.retryInterval, this.connectTimeout, this.queueSize, this.maxBatchTime, this.batchSize, this.cleanupOnShutdown);
    }

    public SensuConfig withNamespace(String namespace) {
        return this.namespace == namespace ? this : new SensuConfig(this.sensuHost, this.sensuPort, this.application, this.hostname, this.cluster, namespace, this.retryInterval, this.connectTimeout, this.queueSize, this.maxBatchTime, this.batchSize, this.cleanupOnShutdown);
    }

    public SensuConfig withRetryInterval(long retryInterval) {
        return this.retryInterval == retryInterval ? this : new SensuConfig(this.sensuHost, this.sensuPort, this.application, this.hostname, this.cluster, this.namespace, retryInterval, this.connectTimeout, this.queueSize, this.maxBatchTime, this.batchSize, this.cleanupOnShutdown);
    }

    public SensuConfig withConnectTimeout(int connectTimeout) {
        return this.connectTimeout == connectTimeout ? this : new SensuConfig(this.sensuHost, this.sensuPort, this.application, this.hostname, this.cluster, this.namespace, this.retryInterval, connectTimeout, this.queueSize, this.maxBatchTime, this.batchSize, this.cleanupOnShutdown);
    }

    public SensuConfig withQueueSize(int queueSize) {
        return this.queueSize == queueSize ? this : new SensuConfig(this.sensuHost, this.sensuPort, this.application, this.hostname, this.cluster, this.namespace, this.retryInterval, this.connectTimeout, queueSize, this.maxBatchTime, this.batchSize, this.cleanupOnShutdown);
    }

    public SensuConfig withMaxBatchTime(long maxBatchTime) {
        return this.maxBatchTime == maxBatchTime ? this : new SensuConfig(this.sensuHost, this.sensuPort, this.application, this.hostname, this.cluster, this.namespace, this.retryInterval, this.connectTimeout, this.queueSize, maxBatchTime, this.batchSize, this.cleanupOnShutdown);
    }

    public SensuConfig withBatchSize(int batchSize) {
        return this.batchSize == batchSize ? this : new SensuConfig(this.sensuHost, this.sensuPort, this.application, this.hostname, this.cluster, this.namespace, this.retryInterval, this.connectTimeout, this.queueSize, this.maxBatchTime, batchSize, this.cleanupOnShutdown);
    }

    public SensuConfig withCleanupOnShutdown(boolean cleanupOnShutdown) {
        return this.cleanupOnShutdown == cleanupOnShutdown ? this : new SensuConfig(this.sensuHost, this.sensuPort, this.application, this.hostname, this.cluster, this.namespace, this.retryInterval, this.connectTimeout, this.queueSize, this.maxBatchTime, this.batchSize, cleanupOnShutdown);
    }

    public static class SensuConfigBuilder {
        private String sensuHost;
        private int sensuPort;
        private String application;
        private String hostname;
        private String cluster;
        private String namespace;
        private long retryInterval;
        private int connectTimeout;
        private int queueSize;
        private long maxBatchTime;
        private int batchSize;
        private boolean cleanupOnShutdown;

        SensuConfigBuilder() {
        }

        public SensuConfigBuilder sensuHost(String sensuHost) {
            this.sensuHost = sensuHost;
            return this;
        }

        public SensuConfigBuilder sensuPort(int sensuPort) {
            this.sensuPort = sensuPort;
            return this;
        }

        public SensuConfigBuilder application(String application) {
            this.application = application;
            return this;
        }

        public SensuConfigBuilder hostname(String hostname) {
            this.hostname = hostname;
            return this;
        }

        public SensuConfigBuilder cluster(String cluster) {
            this.cluster = cluster;
            return this;
        }

        public SensuConfigBuilder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public SensuConfigBuilder retryInterval(long retryInterval) {
            this.retryInterval = retryInterval;
            return this;
        }

        public SensuConfigBuilder connectTimeout(int connectTimeout) {
            this.connectTimeout = connectTimeout;
            return this;
        }

        public SensuConfigBuilder queueSize(int queueSize) {
            this.queueSize = queueSize;
            return this;
        }

        public SensuConfigBuilder maxBatchTime(long maxBatchTime) {
            this.maxBatchTime = maxBatchTime;
            return this;
        }

        public SensuConfigBuilder batchSize(int batchSize) {
            this.batchSize = batchSize;
            return this;
        }

        public SensuConfigBuilder cleanupOnShutdown(boolean cleanupOnShutdown) {
            this.cleanupOnShutdown = cleanupOnShutdown;
            return this;
        }

        public SensuConfig build() {
            return new SensuConfig(this.sensuHost, this.sensuPort, this.application, this.hostname, this.cluster, this.namespace, this.retryInterval, this.connectTimeout, this.queueSize, this.maxBatchTime, this.batchSize, this.cleanupOnShutdown);
        }

        public String toString() {
            return "SensuConfig.SensuConfigBuilder(sensuHost=" + this.sensuHost + ", sensuPort=" + this.sensuPort + ", application=" + this.application + ", hostname=" + this.hostname + ", cluster=" + this.cluster + ", namespace=" + this.namespace + ", retryInterval=" + this.retryInterval + ", connectTimeout=" + this.connectTimeout + ", queueSize=" + this.queueSize + ", maxBatchTime=" + this.maxBatchTime + ", batchSize=" + this.batchSize + ", cleanupOnShutdown=" + this.cleanupOnShutdown + ")";
        }
    }
}

