/*
 * Decompiled with CFR 0.152.
 */
package no.nav.common.metrics;

import java.util.Map;
import java.util.concurrent.TimeUnit;
import no.nav.common.metrics.Event;
import no.nav.common.metrics.InfluxUtils;
import no.nav.common.metrics.MetricsClient;
import no.nav.common.metrics.SensuConfig;
import no.nav.common.metrics.SensuHandler;

public class InfluxClient
implements MetricsClient {
    private final SensuHandler sensuHandler;
    private final SensuConfig sensuConfig;

    public InfluxClient() {
        this(SensuConfig.defaultConfig());
    }

    public InfluxClient(SensuConfig sensuConfig) {
        this.sensuConfig = sensuConfig;
        this.sensuHandler = new SensuHandler(sensuConfig);
    }

    public InfluxClient(SensuConfig sensuConfig, SensuHandler sensuHandler) {
        this.sensuConfig = sensuConfig;
        this.sensuHandler = sensuHandler;
    }

    public void shutdown() {
        this.sensuHandler.shutdown();
    }

    @Override
    public void report(Event event) {
        this.report(event.name, event.fields, event.tags, System.currentTimeMillis());
    }

    @Override
    public void report(String eventName, Map<String, Object> fields, Map<String, String> tags, long timestampInMilliseconds) {
        tags.putIfAbsent("application", this.sensuConfig.getApplication());
        tags.putIfAbsent("hostname", this.sensuConfig.getHostname());
        tags.putIfAbsent("cluster", this.sensuConfig.getCluster());
        tags.putIfAbsent("namespace", this.sensuConfig.getNamespace());
        long timestamp = TimeUnit.MILLISECONDS.toNanos(timestampInMilliseconds);
        String output = InfluxUtils.createInfluxLineProtocolPayload(eventName, tags, fields, timestamp);
        this.sensuHandler.report(output);
    }
}

