/*
 * Decompiled with CFR 0.152.
 */
package no.nav.common.metrics;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.ArrayList;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import no.nav.common.metrics.SensuConfig;
import no.nav.common.utils.MathUtils;
import org.apache.commons.lang3.StringUtils;
import org.json.JSONArray;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SensuHandler {
    private static final Logger log = LoggerFactory.getLogger(SensuHandler.class);
    private final SensuConfig sensuConfig;
    private final LinkedBlockingQueue<String> reportQueue;
    private final ScheduledExecutorService scheduledExecutorService;
    private volatile long queueSisteGangFullTimestamp;
    private volatile boolean isShutDown;

    public SensuHandler(SensuConfig sensuConfig) {
        this.validateSensuConfig(sensuConfig);
        this.sensuConfig = sensuConfig;
        this.reportQueue = new LinkedBlockingQueue(sensuConfig.getQueueSize());
        this.scheduledExecutorService = Executors.newSingleThreadScheduledExecutor();
        this.scheduledExecutorService.execute(new SensuReporter());
        if (sensuConfig.isCleanupOnShutdown()) {
            this.setupShutdownHook();
        }
        log.info("Metrics aktivert med parametre: {}", (Object)sensuConfig);
    }

    private void setupShutdownHook() {
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            if (this.isShutDown) {
                log.info("Sensu is already shut down. Skipping shutdown hook.");
                return;
            }
            this.shutdown();
            log.info("Sensu shutdown hook triggered. Will try to flush leftover metrics.");
            if (!this.reportQueue.isEmpty()) {
                ArrayList reports = new ArrayList();
                this.reportQueue.drainTo(reports, Integer.MAX_VALUE);
                String influxOutput = StringUtils.join(reports, (String)"\n");
                JSONObject jsonObject = this.createJSON(influxOutput);
                try (Socket socket = new Socket();){
                    this.writeToSensu(jsonObject, socket);
                    log.info("Successfully flushed metrics after shutdown. Metrics sent: " + reports.size());
                }
                catch (Exception e) {
                    log.error("Failed to flush metrics after shutdown. Metrics that were not sent: " + reports.size(), (Throwable)e);
                }
            }
        }));
    }

    public void shutdown() {
        this.isShutDown = true;
        try {
            this.scheduledExecutorService.awaitTermination(5L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    void writeToSensu(JSONObject jsonObject, Socket socket) throws IOException {
        BufferedWriter writer = this.connectToSensu(socket);
        writer.write(jsonObject.toString());
        writer.newLine();
        writer.flush();
    }

    private BufferedWriter connectToSensu(Socket socket) throws IOException {
        InetSocketAddress inetSocketAddress = new InetSocketAddress(this.sensuConfig.getSensuHost(), this.sensuConfig.getSensuPort());
        socket.connect(inetSocketAddress, this.sensuConfig.getConnectTimeout());
        return new BufferedWriter(new OutputStreamWriter(socket.getOutputStream()));
    }

    static long calculateBatchTime(int currentQueueSize, int maxQueueSize, long minBatchTime, long maxBatchTime) {
        float percentEmpty = 1.0f - (float)currentQueueSize / (float)maxQueueSize;
        return MathUtils.linearInterpolation((long)minBatchTime, (long)maxBatchTime, (float)percentEmpty);
    }

    private void validateSensuConfig(SensuConfig sensuConfig) {
        if (sensuConfig.getMaxBatchTime() < 100L) {
            throw new IllegalArgumentException("Max batch time must be equal to or above 100");
        }
        if ((long)sensuConfig.getQueueSize() < 100L) {
            throw new IllegalArgumentException("Queue size must be equal to or larger than 100");
        }
    }

    public void report(String output) {
        if (this.isShutDown) {
            log.error("Cannot send report to sensu after shutting down");
            return;
        }
        boolean result = this.reportQueue.offer(output);
        if (!result && System.currentTimeMillis() - this.queueSisteGangFullTimestamp > 60000L) {
            log.error("Sensu-k\u00f8en har v\u00e6rt full, ikke alle metrikker har blitt sendt til Sensu");
            this.queueSisteGangFullTimestamp = System.currentTimeMillis();
        }
    }

    private JSONObject createJSON(String output) {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("name", (Object)this.sensuConfig.getApplication());
        jsonObject.put("type", (Object)"metric");
        jsonObject.put("output", (Object)output);
        jsonObject.put("status", 0);
        jsonObject.put("handlers", (Object)new JSONArray("[events_nano]"));
        return jsonObject;
    }

    private class SensuReporter
    implements Runnable {
        private SensuReporter() {
        }

        @Override
        public void run() {
            ArrayList reports = new ArrayList();
            while (!SensuHandler.this.isShutDown) {
                try {
                    block11: {
                        if (!SensuHandler.this.reportQueue.isEmpty()) {
                            reports.clear();
                            SensuHandler.this.reportQueue.drainTo(reports, SensuHandler.this.sensuConfig.getBatchSize() - 1);
                            float percentFull = (float)SensuHandler.this.reportQueue.size() / (float)SensuHandler.this.sensuConfig.getQueueSize() * 100.0f;
                            log.info(String.format("Metrics still in queue: %d \tQueue full: %.2f%% \tMetrics sent: %d", SensuHandler.this.reportQueue.size(), Float.valueOf(percentFull), reports.size()));
                            String influxOutput = StringUtils.join(reports, (String)"\n");
                            JSONObject jsonObject = SensuHandler.this.createJSON(influxOutput);
                            try (Socket socket = new Socket();){
                                SensuHandler.this.writeToSensu(jsonObject, socket);
                            }
                            catch (IOException e) {
                                SensuHandler.this.reportQueue.addAll(reports);
                                log.error("Noe gikk feil med tilkoblingen til Sensu socket: {} - {}", (Object)e.getClass().getSimpleName(), (Object)e.getMessage());
                                if (SensuHandler.this.isShutDown) break block11;
                                Thread.sleep(SensuHandler.this.sensuConfig.getRetryInterval());
                            }
                        }
                    }
                    if (SensuHandler.this.isShutDown) continue;
                    long batchTime = SensuHandler.calculateBatchTime(SensuHandler.this.reportQueue.size(), SensuHandler.this.sensuConfig.getQueueSize(), 100L, SensuHandler.this.sensuConfig.getMaxBatchTime());
                    Thread.sleep(batchTime);
                }
                catch (InterruptedException e) {
                    log.error("\u00c5 vente p\u00e5 neste objekt ble avbrutt, b\u00f8r ikke kunne skje", (Throwable)e);
                }
            }
        }
    }
}

