/*
 * Decompiled with CFR 0.152.
 */
package no.nav.common.metrics;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.slf4j.MDC;

public class Event {
    final String name;
    final Map<String, Object> fields = new HashMap<String, Object>();
    final Map<String, String> tags = new HashMap<String, String>();
    private static final String[] MDC_VARIABLES = new String[]{"callId", "userId", "requestId", "consumerId"};

    public Event(String name) {
        this.name = name;
        this.addBaseFields();
    }

    public Event addFieldToReport(String fieldName, Object value) {
        this.fields.put(fieldName, value);
        return this;
    }

    public Event addTagToReport(String tagName, String value) {
        this.tags.put(tagName, value);
        return this;
    }

    public Map<String, Object> getFields() {
        return this.fields;
    }

    public Map<String, String> getTags() {
        return this.tags;
    }

    public Event setSuccess() {
        return this.addFieldToReport("success", true);
    }

    public Event setFailed() {
        return this.addFieldToReport("success", false);
    }

    private void addBaseFields() {
        for (String mdcVariable : MDC_VARIABLES) {
            String mdcValue = MDC.get((String)mdcVariable);
            if (!Objects.nonNull(mdcValue)) continue;
            this.addFieldToReport(mdcVariable, mdcValue);
        }
        this.setSuccess();
        this.addFieldToReport("value", 1);
    }
}

