/*
 * Decompiled with CFR 0.152.
 */
package no.nav.common.nais.utils;

import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import no.nav.common.utils.Pair;
import no.nav.sbl.util.EnvironmentUtils;

public class NaisUtils {
    public static String SECRETS_BASE_PATH_PROPERTY_NAME = "SECRETS_BASE_PATH";
    private static String DEFAULT_SECRETS_BASE_PATH = "/var/run/secrets/nais.io";
    private static String DEFAULT_CREDENTIALS_USERNAME_FILE = "username";
    private static String DEFAULT_CREDENTIALS_PASSWORD_FILE = "password";
    public static String CONFIG_MAPS_BASE_PATH_PROPERTY_NAME = "CONFIG_BASE_MAPS_PATH";
    private static String DEFAULT_CONFIG_MAPS_PATH = "/var/run/configmaps";

    public static Credentials getCredentials(String secretName, String usernameFileName, String passwordFileName) {
        String credentialsBasePath = EnvironmentUtils.getOptionalProperty((String)SECRETS_BASE_PATH_PROPERTY_NAME, (String[])new String[0]).orElse(DEFAULT_SECRETS_BASE_PATH);
        Path path = Paths.get(credentialsBasePath, secretName);
        String username = NaisUtils.getFileContent(path.resolve(usernameFileName));
        String password = NaisUtils.getFileContent(path.resolve(passwordFileName));
        return new Credentials(username, password);
    }

    public static Credentials getCredentials(String secretName) {
        return NaisUtils.getCredentials(secretName, DEFAULT_CREDENTIALS_USERNAME_FILE, DEFAULT_CREDENTIALS_PASSWORD_FILE);
    }

    public static String getFileContent(String path) {
        return NaisUtils.getFileContent(Paths.get(path, new String[0]));
    }

    public static String getFileContent(Path path) {
        return (String)Optional.of(path).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).map(NaisUtils::readAllLines).flatMap(lines -> lines.stream().reduce((a, b) -> a + "\n" + b)).orElseThrow(() -> new IllegalStateException(String.format("Fant ikke fil %s", path.toString())));
    }

    private static List<String> readAllLines(Path path) {
        return Files.readAllLines(path);
    }

    public static void addConfigMapToEnv(String configMap) {
        NaisUtils.addMapToEnv(NaisUtils.readConfigMap(configMap));
    }

    public static void addConfigMapToEnv(String configMap, String ... keys) {
        NaisUtils.addMapToEnv(NaisUtils.readConfigMap(configMap, keys));
    }

    private static void addMapToEnv(Map<String, String> map) {
        map.forEach((key, value) -> EnvironmentUtils.setProperty((String)key, (String)value, (EnvironmentUtils.Type)EnvironmentUtils.Type.PUBLIC));
    }

    public static Map<String, String> readConfigMap(String configMap) {
        String configMapsPath = EnvironmentUtils.getOptionalProperty((String)CONFIG_MAPS_BASE_PATH_PROPERTY_NAME, (String[])new String[0]).orElse(DEFAULT_CONFIG_MAPS_PATH);
        Path path = Paths.get(configMapsPath, configMap);
        Stream<Path> files = Files.walk(path, 1, new FileVisitOption[0]).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0]));
        return files.collect(Collectors.toMap(file -> file.getFileName().toString(), NaisUtils::getFileContent));
    }

    public static Map<String, String> readConfigMap(String configMap, String ... keys) {
        Map<String, String> configMapMap = NaisUtils.readConfigMap(configMap);
        return Arrays.stream(keys).map(key -> Optional.ofNullable(configMapMap.get(key)).map(value -> Pair.of((Object)key, (Object)value)).orElseThrow(() -> new IllegalStateException(String.format("Fant ikke key %s i config map %s", key, configMap)))).collect(Collectors.toMap(Pair::getFirst, Pair::getSecond));
    }

    public static class Credentials {
        public final String username;
        public final String password;

        private Credentials(String username, String password) {
            this.username = username;
            this.password = password;
        }
    }
}

