/*
 * Decompiled with CFR 0.152.
 */
package no.nav.common.oidc.auth;

import no.nav.brukerdialog.security.domain.IdentType;

public class OidcAuthenticatorConfig {
    public String discoveryUrl;
    public String clientId;
    public String idTokenCookieName;
    public IdentType identType;
    public String refreshTokenCookieName;
    public String refreshUrl;

    public boolean isValid() {
        return this.discoveryUrl != null && this.clientId != null && this.idTokenCookieName != null && this.identType != null;
    }

    public OidcAuthenticatorConfig withDiscoveryUrl(String discoveryUrl) {
        return this.discoveryUrl == discoveryUrl ? this : new OidcAuthenticatorConfig(discoveryUrl, this.clientId, this.idTokenCookieName, this.identType, this.refreshTokenCookieName, this.refreshUrl);
    }

    public OidcAuthenticatorConfig withClientId(String clientId) {
        return this.clientId == clientId ? this : new OidcAuthenticatorConfig(this.discoveryUrl, clientId, this.idTokenCookieName, this.identType, this.refreshTokenCookieName, this.refreshUrl);
    }

    public OidcAuthenticatorConfig withIdTokenCookieName(String idTokenCookieName) {
        return this.idTokenCookieName == idTokenCookieName ? this : new OidcAuthenticatorConfig(this.discoveryUrl, this.clientId, idTokenCookieName, this.identType, this.refreshTokenCookieName, this.refreshUrl);
    }

    public OidcAuthenticatorConfig withIdentType(IdentType identType) {
        return this.identType == identType ? this : new OidcAuthenticatorConfig(this.discoveryUrl, this.clientId, this.idTokenCookieName, identType, this.refreshTokenCookieName, this.refreshUrl);
    }

    public OidcAuthenticatorConfig withRefreshTokenCookieName(String refreshTokenCookieName) {
        return this.refreshTokenCookieName == refreshTokenCookieName ? this : new OidcAuthenticatorConfig(this.discoveryUrl, this.clientId, this.idTokenCookieName, this.identType, refreshTokenCookieName, this.refreshUrl);
    }

    public OidcAuthenticatorConfig withRefreshUrl(String refreshUrl) {
        return this.refreshUrl == refreshUrl ? this : new OidcAuthenticatorConfig(this.discoveryUrl, this.clientId, this.idTokenCookieName, this.identType, this.refreshTokenCookieName, refreshUrl);
    }

    public OidcAuthenticatorConfig() {
    }

    public OidcAuthenticatorConfig(String discoveryUrl, String clientId, String idTokenCookieName, IdentType identType, String refreshTokenCookieName, String refreshUrl) {
        this.discoveryUrl = discoveryUrl;
        this.clientId = clientId;
        this.idTokenCookieName = idTokenCookieName;
        this.identType = identType;
        this.refreshTokenCookieName = refreshTokenCookieName;
        this.refreshUrl = refreshUrl;
    }
}

