/*
 * Decompiled with CFR 0.152.
 */
package no.nav.common.oidc.auth;

import no.nav.brukerdialog.security.domain.IdentType;
import no.nav.common.oidc.OidcTokenValidator;
import no.nav.common.oidc.auth.OidcAuthenticatorConfig;
import no.nav.common.oidc.utils.TokenLocator;

public final class OidcAuthenticator {
    public final OidcTokenValidator tokenValidator;
    public final TokenLocator tokenLocator;
    public final IdentType identType;
    public final String refreshUrl;

    public static OidcAuthenticator fromConfig(OidcAuthenticatorConfig config) {
        if (!config.isValid()) {
            throw new IllegalStateException("OidcAuthenticatorConfig is missing one or more values");
        }
        OidcTokenValidator validator = new OidcTokenValidator(config.discoveryUrl, config.clientId);
        TokenLocator locator = new TokenLocator(config.idTokenCookieName, config.refreshTokenCookieName);
        return new OidcAuthenticator(validator, locator, config.identType, config.refreshUrl);
    }

    public OidcAuthenticator(OidcTokenValidator tokenValidator, TokenLocator tokenLocator, IdentType identType, String refreshUrl) {
        this.tokenValidator = tokenValidator;
        this.tokenLocator = tokenLocator;
        this.identType = identType;
        this.refreshUrl = refreshUrl;
    }

    public OidcTokenValidator getTokenValidator() {
        return this.tokenValidator;
    }

    public TokenLocator getTokenLocator() {
        return this.tokenLocator;
    }

    public IdentType getIdentType() {
        return this.identType;
    }

    public String getRefreshUrl() {
        return this.refreshUrl;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OidcAuthenticator)) {
            return false;
        }
        OidcAuthenticator other = (OidcAuthenticator)o;
        OidcTokenValidator this$tokenValidator = this.getTokenValidator();
        OidcTokenValidator other$tokenValidator = other.getTokenValidator();
        if (this$tokenValidator == null ? other$tokenValidator != null : !this$tokenValidator.equals(other$tokenValidator)) {
            return false;
        }
        TokenLocator this$tokenLocator = this.getTokenLocator();
        TokenLocator other$tokenLocator = other.getTokenLocator();
        if (this$tokenLocator == null ? other$tokenLocator != null : !this$tokenLocator.equals(other$tokenLocator)) {
            return false;
        }
        IdentType this$identType = this.getIdentType();
        IdentType other$identType = other.getIdentType();
        if (this$identType == null ? other$identType != null : !this$identType.equals(other$identType)) {
            return false;
        }
        String this$refreshUrl = this.getRefreshUrl();
        String other$refreshUrl = other.getRefreshUrl();
        return !(this$refreshUrl == null ? other$refreshUrl != null : !this$refreshUrl.equals(other$refreshUrl));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        OidcTokenValidator $tokenValidator = this.getTokenValidator();
        result = result * 59 + ($tokenValidator == null ? 43 : $tokenValidator.hashCode());
        TokenLocator $tokenLocator = this.getTokenLocator();
        result = result * 59 + ($tokenLocator == null ? 43 : $tokenLocator.hashCode());
        IdentType $identType = this.getIdentType();
        result = result * 59 + ($identType == null ? 43 : $identType.hashCode());
        String $refreshUrl = this.getRefreshUrl();
        result = result * 59 + ($refreshUrl == null ? 43 : $refreshUrl.hashCode());
        return result;
    }

    public String toString() {
        return "OidcAuthenticator(tokenValidator=" + this.getTokenValidator() + ", tokenLocator=" + this.getTokenLocator() + ", identType=" + this.getIdentType() + ", refreshUrl=" + this.getRefreshUrl() + ")";
    }
}

