/*
 * Decompiled with CFR 0.152.
 */
package no.nav.common.oidc.utils;

import javax.ws.rs.client.Client;
import javax.ws.rs.client.Entity;
import javax.ws.rs.core.Response;
import no.nav.sbl.rest.RestUtils;

public class TokenRefreshClient {
    private final Client client;

    public TokenRefreshClient() {
        this(RestUtils.createClient());
    }

    TokenRefreshClient(Client client) {
        this.client = client;
    }

    public String refreshIdToken(String refreshUrl, String refreshToken) {
        Response response = this.client.target(refreshUrl).request().post(Entity.json((Object)new RefreshIdTokenRequest(refreshToken)));
        if (response.getStatus() >= 300) {
            String responseStr = (String)response.readEntity(String.class);
            throw new RuntimeException(String.format("Received unexpected status %d from %s when refreshing id token. Response: %s", response.getStatus(), refreshUrl, responseStr));
        }
        return ((RefreshIdTokenResponse)response.readEntity(RefreshIdTokenResponse.class)).idToken;
    }

    public static class RefreshIdTokenResponse {
        public String idToken;

        public RefreshIdTokenResponse() {
        }

        public RefreshIdTokenResponse(String idToken) {
            this.idToken = idToken;
        }
    }

    public static class RefreshIdTokenRequest {
        public String refreshToken;

        public RefreshIdTokenRequest() {
        }

        public RefreshIdTokenRequest(String refreshToken) {
            this.refreshToken = refreshToken;
        }
    }
}

