/*
 * Decompiled with CFR 0.152.
 */
package no.nav.common.oidc;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.nimbusds.jwt.JWT;
import com.nimbusds.jwt.JWTParser;
import javax.ws.rs.client.Client;
import javax.ws.rs.core.Response;
import no.nav.common.oidc.discovery.OidcDiscoveryConfiguration;
import no.nav.common.oidc.discovery.OidcDiscoveryConfigurationClient;
import no.nav.common.oidc.utils.TokenUtils;
import no.nav.common.utils.AuthUtils;
import no.nav.sbl.rest.RestUtils;

public class SystemUserTokenProvider {
    private static final int MINIMUM_TIME_TO_EXPIRE_BEFORE_REFRESH = 60000;
    private final Client client;
    private final String tokenEndpoint;
    private final String srvUsername;
    private final String srvPassword;
    private JWT accessToken;

    public SystemUserTokenProvider(String discoveryUrl, String srvUsername, String srvPassword) {
        OidcDiscoveryConfigurationClient client = new OidcDiscoveryConfigurationClient();
        OidcDiscoveryConfiguration configuration = client.fetchDiscoveryConfiguration(discoveryUrl);
        this.tokenEndpoint = configuration.tokenEndpoint;
        this.srvUsername = srvUsername;
        this.srvPassword = srvPassword;
        this.client = RestUtils.createClient();
    }

    public SystemUserTokenProvider(String tokenEndpoint, String srvUsername, String srvPassword, Client client) {
        this.tokenEndpoint = tokenEndpoint;
        this.srvUsername = srvUsername;
        this.srvPassword = srvPassword;
        this.client = client;
    }

    public String getSystemUserAccessToken() {
        if (this.tokenIsSoonExpired()) {
            this.refreshToken();
        }
        return this.accessToken.getParsedString();
    }

    private void refreshToken() {
        ClientCredentialsResponse clientCredentials = this.fetchSystemUserAccessToken();
        this.accessToken = JWTParser.parse((String)clientCredentials.accessToken);
    }

    private boolean tokenIsSoonExpired() {
        return this.accessToken == null || TokenUtils.expiresWithin(this.accessToken, 60000L);
    }

    private ClientCredentialsResponse fetchSystemUserAccessToken() {
        String targetUrl = this.tokenEndpoint + "?grant_type=client_credentials&scope=openid";
        String basicAuth = AuthUtils.basicCredentials((String)this.srvUsername, (String)this.srvPassword);
        Response response = this.client.target(targetUrl).request().header("Content-Type", (Object)"application/x-www-form-urlencoded").header("Authorization", (Object)basicAuth).get();
        if (response.getStatus() >= 300) {
            String responseStr = (String)response.readEntity(String.class);
            throw new RuntimeException(String.format("Received unexpected status %d when requesting access token for system user. Response: %s", response.getStatus(), responseStr));
        }
        return (ClientCredentialsResponse)response.readEntity(ClientCredentialsResponse.class);
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class ClientCredentialsResponse {
        @JsonProperty(value="access_token")
        public String accessToken;
    }
}

