/*
 * Decompiled with CFR 0.152.
 */
package no.nav.common.oidc.utils;

import java.util.Optional;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import no.nav.common.oidc.utils.CookieUtils;
import no.nav.common.oidc.utils.TokenFinder;

public class CookieTokenFinder
implements TokenFinder {
    private final String cookieName;

    public CookieTokenFinder(String cookieName) {
        this.cookieName = cookieName;
    }

    @Override
    public Optional<String> findToken(HttpServletRequest request) {
        return CookieUtils.getCookie(this.cookieName, request).map(Cookie::getValue);
    }
}

