/*
 * Decompiled with CFR 0.152.
 */
package no.nav.sbl.rest;

import java.beans.ConstructorProperties;
import java.io.IOException;
import java.net.URI;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.ws.rs.client.ClientRequestContext;
import javax.ws.rs.client.ClientRequestFilter;
import javax.ws.rs.client.ClientResponseContext;
import javax.ws.rs.client.ClientResponseFilter;
import javax.ws.rs.core.Cookie;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.UriBuilder;
import no.nav.log.LogFilter;
import no.nav.metrics.MetricsFactory;
import no.nav.metrics.Timer;
import no.nav.sbl.util.EnvironmentUtils;
import no.nav.sbl.util.ExceptionUtils;
import no.nav.sbl.util.ListUtils;
import no.nav.sbl.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public class ClientLogFilter
implements ClientResponseFilter,
ClientRequestFilter {
    private static final Logger LOG = LoggerFactory.getLogger(ClientLogFilter.class);
    private static final String NAME = ClientLogFilter.class.getName();
    private static final String CSRF_TOKEN = "csrf-token";
    private final ClientLogFilterConfig filterConfig;

    public ClientLogFilter(ClientLogFilterConfig filterConfig) {
        this.filterConfig = filterConfig;
    }

    public void filter(ClientRequestContext clientRequestContext) throws IOException {
        LOG.info("{} {}", (Object)clientRequestContext.getMethod(), (Object)this.uriForLogging(clientRequestContext));
        MultivaluedMap requestHeaders = clientRequestContext.getHeaders();
        StringUtils.of((String)MDC.get((String)"callId")).ifPresent(callId -> Arrays.stream(LogFilter.NAV_CALL_ID_HEADER_NAMES).forEach(headerName -> requestHeaders.add(headerName, callId)));
        EnvironmentUtils.getApplicationName().ifPresent(applicationName -> requestHeaders.add((Object)"Nav-Consumer-Id", applicationName));
        requestHeaders.add((Object)"NAV_CSRF_PROTECTION", (Object)CSRF_TOKEN);
        requestHeaders.add((Object)"Cookie", (Object)new Cookie("NAV_CSRF_PROTECTION", CSRF_TOKEN));
        requestHeaders.replace((Object)"Cookie", (Object)ListUtils.mutableList((Object[])new Object[]{((List)requestHeaders.get((Object)"Cookie")).stream().map(this::toCookieString).collect(Collectors.joining("; "))}));
        if (!this.filterConfig.disableMetrics) {
            Timer timer = MetricsFactory.createTimer((String)this.filterConfig.metricName);
            timer.start();
            clientRequestContext.setProperty(NAME, (Object)new Data(timer));
        }
    }

    private String toCookieString(Object cookie) {
        if (cookie instanceof String) {
            return (String)cookie;
        }
        if (cookie instanceof Cookie) {
            Cookie c = (Cookie)cookie;
            return c.getName() + "=" + c.getValue();
        }
        throw new IllegalArgumentException();
    }

    public void filter(ClientRequestContext clientRequestContext, ClientResponseContext clientResponseContext) throws IOException {
        this.requestComplete(clientRequestContext, clientResponseContext.getStatus(), null);
    }

    public void requestFailed(ClientRequestContext request, Throwable throwable) {
        LOG.warn(throwable.getMessage(), throwable);
        this.requestComplete(request, 520, throwable);
    }

    private void requestComplete(ClientRequestContext clientRequestContext, int status, Throwable throwable) {
        if (!this.filterConfig.disableMetrics) {
            Data data = (Data)clientRequestContext.getProperty(NAME);
            Timer timer = data.timer;
            URI uri = clientRequestContext.getUri();
            String host = uri.getHost();
            ((Timer)((Timer)((Timer)timer.stop().addFieldToReport("httpStatus", (Object)status)).addFieldToReport("host", (Object)host)).addFieldToReport("path", (Object)uri.getPath())).report();
            MetricsFactory.getMeterRegistry().timer("rest_client", new String[]{"host", host, "status", Integer.toString(status), "error", Optional.ofNullable(throwable).map(ExceptionUtils::getRootCause).map(t -> t.getClass().getSimpleName()).orElse("")}).record(System.currentTimeMillis() - data.invocationTimestamp, TimeUnit.MILLISECONDS);
        }
    }

    private URI uriForLogging(ClientRequestContext clientRequestContext) {
        URI uri = clientRequestContext.getUri();
        return this.filterConfig.disableParameterLogging ? UriBuilder.fromUri((URI)uri).replaceQuery("").build(new Object[0]) : uri;
    }

    private static class Data {
        private final long invocationTimestamp = System.currentTimeMillis();
        private final Timer timer;

        private Data(Timer timer) {
            this.timer = timer;
        }
    }

    public static final class ClientLogFilterConfig {
        public final String metricName;
        public final boolean disableMetrics;
        public final boolean disableParameterLogging;

        @ConstructorProperties(value={"metricName", "disableMetrics", "disableParameterLogging"})
        ClientLogFilterConfig(String metricName, boolean disableMetrics, boolean disableParameterLogging) {
            this.metricName = metricName;
            this.disableMetrics = disableMetrics;
            this.disableParameterLogging = disableParameterLogging;
        }

        public static ClientLogFilterConfigBuilder builder() {
            return new ClientLogFilterConfigBuilder();
        }

        public String getMetricName() {
            return this.metricName;
        }

        public boolean isDisableMetrics() {
            return this.disableMetrics;
        }

        public boolean isDisableParameterLogging() {
            return this.disableParameterLogging;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ClientLogFilterConfig)) {
                return false;
            }
            ClientLogFilterConfig other = (ClientLogFilterConfig)o;
            String this$metricName = this.getMetricName();
            String other$metricName = other.getMetricName();
            if (this$metricName == null ? other$metricName != null : !this$metricName.equals(other$metricName)) {
                return false;
            }
            if (this.isDisableMetrics() != other.isDisableMetrics()) {
                return false;
            }
            return this.isDisableParameterLogging() == other.isDisableParameterLogging();
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $metricName = this.getMetricName();
            result = result * 59 + ($metricName == null ? 43 : $metricName.hashCode());
            result = result * 59 + (this.isDisableMetrics() ? 79 : 97);
            result = result * 59 + (this.isDisableParameterLogging() ? 79 : 97);
            return result;
        }

        public String toString() {
            return "ClientLogFilter.ClientLogFilterConfig(metricName=" + this.getMetricName() + ", disableMetrics=" + this.isDisableMetrics() + ", disableParameterLogging=" + this.isDisableParameterLogging() + ")";
        }

        public ClientLogFilterConfig withMetricName(String metricName) {
            return this.metricName == metricName ? this : new ClientLogFilterConfig(metricName, this.disableMetrics, this.disableParameterLogging);
        }

        public ClientLogFilterConfig withDisableMetrics(boolean disableMetrics) {
            return this.disableMetrics == disableMetrics ? this : new ClientLogFilterConfig(this.metricName, disableMetrics, this.disableParameterLogging);
        }

        public ClientLogFilterConfig withDisableParameterLogging(boolean disableParameterLogging) {
            return this.disableParameterLogging == disableParameterLogging ? this : new ClientLogFilterConfig(this.metricName, this.disableMetrics, disableParameterLogging);
        }

        public static class ClientLogFilterConfigBuilder {
            private String metricName;
            private boolean disableMetrics;
            private boolean disableParameterLogging;

            ClientLogFilterConfigBuilder() {
            }

            public ClientLogFilterConfigBuilder metricName(String metricName) {
                this.metricName = metricName;
                return this;
            }

            public ClientLogFilterConfigBuilder disableMetrics(boolean disableMetrics) {
                this.disableMetrics = disableMetrics;
                return this;
            }

            public ClientLogFilterConfigBuilder disableParameterLogging(boolean disableParameterLogging) {
                this.disableParameterLogging = disableParameterLogging;
                return this;
            }

            public ClientLogFilterConfig build() {
                return new ClientLogFilterConfig(this.metricName, this.disableMetrics, this.disableParameterLogging);
            }

            public String toString() {
                return "ClientLogFilter.ClientLogFilterConfig.ClientLogFilterConfigBuilder(metricName=" + this.metricName + ", disableMetrics=" + this.disableMetrics + ", disableParameterLogging=" + this.disableParameterLogging + ")";
            }
        }
    }
}

