/*
 * Decompiled with CFR 0.152.
 */
package no.nav.sbl.rest;

import java.util.function.Function;
import javax.net.ssl.SSLContext;
import javax.ws.rs.client.Client;
import javax.ws.rs.core.Configuration;
import no.nav.json.JsonProvider;
import no.nav.sbl.rest.ClientLogFilter;
import no.nav.sbl.rest.client.MetricsConnectorProvider;
import org.glassfish.jersey.client.ClientConfig;
import org.glassfish.jersey.client.JerseyClientBuilder;
import org.glassfish.jersey.client.spi.ConnectorProvider;

public class RestUtils {
    public static final String CSRF_COOKIE_NAVN = "NAV_CSRF_PROTECTION";
    public static final RestConfig DEFAULT_CONFIG = RestConfig.builder().build();
    public static final RestConfig LONG_READ_CONFIG = DEFAULT_CONFIG.withReadTimeout(RestUtils.DEFAULT_CONFIG.readTimeout * 4);

    public static ClientConfig createClientConfig() {
        return RestUtils.createClientConfig(DEFAULT_CONFIG, RestUtils.getMetricName());
    }

    public static ClientConfig createClientConfig(RestConfig restConfig) {
        return RestUtils.createClientConfig(restConfig, RestUtils.getMetricName());
    }

    private static ClientConfig createClientConfig(RestConfig restConfig, String metricName) {
        ClientLogFilter clientLogFilter = new ClientLogFilter(ClientLogFilter.ClientLogFilterConfig.builder().disableMetrics(restConfig.disableMetrics).disableParameterLogging(restConfig.disableParameterLogging).metricName(metricName).build());
        ClientConfig clientConfig = new ClientConfig();
        clientConfig.register((Object)new JsonProvider());
        clientConfig.register((Object)clientLogFilter);
        clientConfig.property("jersey.config.client.followRedirects", (Object)false);
        clientConfig.property("jersey.config.client.connectTimeout", (Object)restConfig.connectTimeout);
        clientConfig.property("jersey.config.client.readTimeout", (Object)restConfig.readTimeout);
        clientConfig.connectorProvider((ConnectorProvider)new MetricsConnectorProvider(clientConfig.getConnectorProvider(), clientLogFilter));
        return clientConfig;
    }

    public static Client createClient() {
        return RestUtils.createClient(DEFAULT_CONFIG, RestUtils.getMetricName());
    }

    public static Client createClient(RestConfig restConfig) {
        return RestUtils.createClient(restConfig, RestUtils.getMetricName());
    }

    private static Client createClient(RestConfig restConfig, String metricName) {
        return new JerseyClientBuilder().sslContext(RestUtils.riktigSSLContext()).withConfig((Configuration)RestUtils.createClientConfig(restConfig, metricName)).build();
    }

    public static <T> T withClient(Function<Client, T> function) {
        return RestUtils.withClient(DEFAULT_CONFIG, function, RestUtils.getMetricName());
    }

    public static <T> T withClient(RestConfig restConfig, Function<Client, T> function) {
        return RestUtils.withClient(restConfig, function, RestUtils.getMetricName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <T> T withClient(RestConfig restConfig, Function<Client, T> function, String metricName) {
        try (Client client = RestUtils.createClient(restConfig, metricName);){
            T t = function.apply(client);
            return t;
        }
    }

    private static SSLContext riktigSSLContext() {
        return SSLContext.getDefault();
    }

    private static String getMetricName() {
        StackTraceElement element = Thread.currentThread().getStackTrace()[3];
        return String.format("rest.client.%s.%s", element.getClassName(), element.getMethodName());
    }

    public static final class RestConfig {
        public final int connectTimeout;
        public final int readTimeout;
        public final boolean disableMetrics;
        public final boolean disableParameterLogging;

        private static int $default$connectTimeout() {
            return 5000;
        }

        private static int $default$readTimeout() {
            return 15000;
        }

        RestConfig(int connectTimeout, int readTimeout, boolean disableMetrics, boolean disableParameterLogging) {
            this.connectTimeout = connectTimeout;
            this.readTimeout = readTimeout;
            this.disableMetrics = disableMetrics;
            this.disableParameterLogging = disableParameterLogging;
        }

        public static RestConfigBuilder builder() {
            return new RestConfigBuilder();
        }

        public int getConnectTimeout() {
            return this.connectTimeout;
        }

        public int getReadTimeout() {
            return this.readTimeout;
        }

        public boolean isDisableMetrics() {
            return this.disableMetrics;
        }

        public boolean isDisableParameterLogging() {
            return this.disableParameterLogging;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof RestConfig)) {
                return false;
            }
            RestConfig other = (RestConfig)o;
            if (this.getConnectTimeout() != other.getConnectTimeout()) {
                return false;
            }
            if (this.getReadTimeout() != other.getReadTimeout()) {
                return false;
            }
            if (this.isDisableMetrics() != other.isDisableMetrics()) {
                return false;
            }
            return this.isDisableParameterLogging() == other.isDisableParameterLogging();
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getConnectTimeout();
            result = result * 59 + this.getReadTimeout();
            result = result * 59 + (this.isDisableMetrics() ? 79 : 97);
            result = result * 59 + (this.isDisableParameterLogging() ? 79 : 97);
            return result;
        }

        public String toString() {
            return "RestUtils.RestConfig(connectTimeout=" + this.getConnectTimeout() + ", readTimeout=" + this.getReadTimeout() + ", disableMetrics=" + this.isDisableMetrics() + ", disableParameterLogging=" + this.isDisableParameterLogging() + ")";
        }

        public RestConfig withConnectTimeout(int connectTimeout) {
            return this.connectTimeout == connectTimeout ? this : new RestConfig(connectTimeout, this.readTimeout, this.disableMetrics, this.disableParameterLogging);
        }

        public RestConfig withReadTimeout(int readTimeout) {
            return this.readTimeout == readTimeout ? this : new RestConfig(this.connectTimeout, readTimeout, this.disableMetrics, this.disableParameterLogging);
        }

        public RestConfig withDisableMetrics(boolean disableMetrics) {
            return this.disableMetrics == disableMetrics ? this : new RestConfig(this.connectTimeout, this.readTimeout, disableMetrics, this.disableParameterLogging);
        }

        public RestConfig withDisableParameterLogging(boolean disableParameterLogging) {
            return this.disableParameterLogging == disableParameterLogging ? this : new RestConfig(this.connectTimeout, this.readTimeout, this.disableMetrics, disableParameterLogging);
        }

        public static class RestConfigBuilder {
            private boolean connectTimeout$set;
            private int connectTimeout;
            private boolean readTimeout$set;
            private int readTimeout;
            private boolean disableMetrics;
            private boolean disableParameterLogging;

            RestConfigBuilder() {
            }

            public RestConfigBuilder connectTimeout(int connectTimeout) {
                this.connectTimeout = connectTimeout;
                this.connectTimeout$set = true;
                return this;
            }

            public RestConfigBuilder readTimeout(int readTimeout) {
                this.readTimeout = readTimeout;
                this.readTimeout$set = true;
                return this;
            }

            public RestConfigBuilder disableMetrics(boolean disableMetrics) {
                this.disableMetrics = disableMetrics;
                return this;
            }

            public RestConfigBuilder disableParameterLogging(boolean disableParameterLogging) {
                this.disableParameterLogging = disableParameterLogging;
                return this;
            }

            public RestConfig build() {
                int connectTimeout = this.connectTimeout;
                if (!this.connectTimeout$set) {
                    connectTimeout = RestConfig.$default$connectTimeout();
                }
                int readTimeout = this.readTimeout;
                if (!this.readTimeout$set) {
                    readTimeout = RestConfig.$default$readTimeout();
                }
                return new RestConfig(connectTimeout, readTimeout, this.disableMetrics, this.disableParameterLogging);
            }

            public String toString() {
                return "RestUtils.RestConfig.RestConfigBuilder(connectTimeout=" + this.connectTimeout + ", readTimeout=" + this.readTimeout + ", disableMetrics=" + this.disableMetrics + ", disableParameterLogging=" + this.disableParameterLogging + ")";
            }
        }
    }
}

