/*
 * Decompiled with CFR 0.152.
 */
package no.nav.sbl.rest.client;

import java.util.concurrent.Future;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientRequestContext;
import javax.ws.rs.core.Configuration;
import no.nav.sbl.rest.ClientLogFilter;
import org.glassfish.jersey.client.ClientRequest;
import org.glassfish.jersey.client.ClientResponse;
import org.glassfish.jersey.client.spi.AsyncConnectorCallback;
import org.glassfish.jersey.client.spi.Connector;
import org.glassfish.jersey.client.spi.ConnectorProvider;

public class MetricsConnectorProvider
implements ConnectorProvider {
    private final ClientLogFilter clientLogFilter;
    private final ConnectorProvider connectorProvider;

    public MetricsConnectorProvider(ConnectorProvider connectorProvider, ClientLogFilter clientLogFilter) {
        this.connectorProvider = connectorProvider;
        this.clientLogFilter = clientLogFilter;
    }

    public Connector getConnector(Client client, Configuration runtimeConfig) {
        return new MetricsConnector(this.connectorProvider.getConnector(client, runtimeConfig));
    }

    private class MetricsConnector
    implements Connector {
        private final Connector connector;

        public MetricsConnector(Connector connector) {
            this.connector = connector;
        }

        public ClientResponse apply(ClientRequest request) {
            try {
                return this.connector.apply(request);
            }
            catch (Throwable t) {
                MetricsConnectorProvider.this.clientLogFilter.requestFailed((ClientRequestContext)request, t);
                throw t;
            }
        }

        public Future<?> apply(ClientRequest request, AsyncConnectorCallback callback) {
            return this.connector.apply(request, callback);
        }

        public String getName() {
            return this.connector.getName();
        }

        public void close() {
            this.connector.close();
        }
    }
}

