/*
 * Decompiled with CFR 0.152.
 */
package no.nav.common.rest;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import javax.ws.rs.client.ClientRequestContext;
import javax.ws.rs.client.ClientRequestFilter;
import javax.ws.rs.core.Cookie;
import javax.ws.rs.core.MultivaluedMap;
import no.nav.common.log.LogFilter;
import no.nav.common.utils.EnvironmentUtils;
import no.nav.common.utils.ListUtils;
import no.nav.common.utils.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public class RequestFilter
implements ClientRequestFilter {
    private static final Logger LOG = LoggerFactory.getLogger(RequestFilter.class);
    private static final String CSRF_TOKEN = "csrf-token";

    public void filter(ClientRequestContext requestContext) {
        LOG.info("{} {}", (Object)requestContext.getMethod(), (Object)requestContext.getUri());
        MultivaluedMap requestHeaders = requestContext.getHeaders();
        StringUtils.of((String)MDC.get((String)"callId")).ifPresent(callId -> Arrays.stream(LogFilter.NAV_CALL_ID_HEADER_NAMES).forEach(headerName -> requestHeaders.add(headerName, callId)));
        EnvironmentUtils.getApplicationName().ifPresent(applicationName -> requestHeaders.add((Object)"Nav-Consumer-Id", applicationName));
        requestHeaders.add((Object)"NAV_CSRF_PROTECTION", (Object)CSRF_TOKEN);
        requestHeaders.add((Object)"Cookie", (Object)new Cookie("NAV_CSRF_PROTECTION", CSRF_TOKEN));
        requestHeaders.replace((Object)"Cookie", (Object)ListUtils.mutableList((Object[])new Object[]{((List)requestHeaders.get((Object)"Cookie")).stream().map(this::toCookieString).collect(Collectors.joining("; "))}));
    }

    private String toCookieString(Object cookie) {
        if (cookie instanceof String) {
            return (String)cookie;
        }
        if (cookie instanceof Cookie) {
            Cookie c = (Cookie)cookie;
            return c.getName() + "=" + c.getValue();
        }
        throw new IllegalArgumentException();
    }
}

