/*
 * Decompiled with CFR 0.152.
 */
package no.nav.common.rest.client;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.List;
import java.util.function.Function;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.GenericType;

public class RestRequest {
    private final Function<Invocation.Builder, Invocation.Builder> decorator;
    private WebTarget webTarget;

    public RestRequest(Function<Invocation.Builder, Invocation.Builder> decorator, WebTarget webTarget) {
        this.decorator = decorator;
        this.webTarget = webTarget;
    }

    public RestRequest queryParam(String name, Object value) {
        this.webTarget = this.webTarget.queryParam(name, new Object[]{value});
        return this;
    }

    public <ELEMENT> List<ELEMENT> getList(Class<ELEMENT> responseClass) {
        return (List)this.decorator.apply(this.webTarget.request().header("Accept", (Object)"application/json")).get(new GenericType((Type)new ListType(responseClass)));
    }

    private static class ListType
    implements ParameterizedType {
        private final Class<?> elementType;

        public ListType(Class<?> elementType) {
            this.elementType = elementType;
        }

        @Override
        public Type[] getActualTypeArguments() {
            return new Type[]{this.elementType};
        }

        @Override
        public Type getRawType() {
            return List.class;
        }

        @Override
        public Type getOwnerType() {
            return List.class;
        }
    }
}

