/*
 * Decompiled with CFR 0.152.
 */
package no.nav.common.rest.client;

import java.io.IOException;
import java.util.Arrays;
import no.nav.common.log.LogFilter;
import no.nav.common.utils.EnvironmentUtils;
import no.nav.common.utils.StringUtils;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public class LogInterceptor
implements Interceptor {
    private static final Logger log = LoggerFactory.getLogger(LogInterceptor.class);

    public Response intercept(Interceptor.Chain chain) throws IOException {
        Request original = chain.request();
        Request.Builder requestBuilder = original.newBuilder();
        StringUtils.of((String)MDC.get((String)"callId")).or(() -> StringUtils.of((String)MDC.get((String)"jobId"))).ifPresent(callId -> Arrays.stream(LogFilter.NAV_CALL_ID_HEADER_NAMES).forEach(headerName -> requestBuilder.header(headerName, callId)));
        EnvironmentUtils.getApplicationName().ifPresent(applicationName -> requestBuilder.header("Nav-Consumer-Id", applicationName));
        Request request = requestBuilder.method(original.method(), original.body()).build();
        try {
            Response response = chain.proceed(request);
            log.info(String.format("%d %s %s", response.code(), request.method(), request.url()));
            return response;
        }
        catch (Exception exception) {
            log.error(String.format("Request failed: %s %s", request.method(), request.url()), (Throwable)exception);
            throw exception;
        }
    }
}

