/*
 * Decompiled with CFR 0.152.
 */
package no.nav.common.rest.filter;

import java.io.IOException;
import java.util.Optional;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConsumerIdComplianceFilter
implements Filter {
    private static final Logger log = LoggerFactory.getLogger(ConsumerIdComplianceFilter.class);
    private final boolean enforceCompliance;

    public ConsumerIdComplianceFilter(boolean enforceCompliance) {
        this.enforceCompliance = enforceCompliance;
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        boolean isMissingConsumerId = this.getHeader(request, "Nav-Consumer-Id").isEmpty();
        if (isMissingConsumerId) {
            log.warn("Request is missing consumer id, enforcingCompliance={}", (Object)this.enforceCompliance);
            if (this.enforceCompliance) {
                HttpServletResponse response = (HttpServletResponse)servletResponse;
                response.setStatus(400);
                response.getWriter().write("Bad request: Consumer id is missing from header: Nav-Consumer-Id. Make sure to set the header with the name of the requesting application.");
                response.getWriter().flush();
                return;
            }
        }
        chain.doFilter(servletRequest, servletResponse);
    }

    public void init(FilterConfig filterConfig) {
    }

    public void destroy() {
    }

    private Optional<String> getHeader(HttpServletRequest request, String headerName) {
        return Optional.ofNullable(request.getHeader(headerName));
    }
}

