/*
 * Decompiled with CFR 0.152.
 */
package no.nav.common.rest.client;

import java.io.IOException;
import no.nav.common.utils.EnvironmentUtils;
import no.nav.common.utils.IdUtils;
import no.nav.common.utils.StringUtils;
import okhttp3.HttpUrl;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public class LogRequestInterceptor
implements Interceptor {
    private static final Logger log = LoggerFactory.getLogger(LogRequestInterceptor.class);

    public Response intercept(Interceptor.Chain chain) throws IOException {
        Request original = chain.request();
        Request.Builder requestBuilder = original.newBuilder();
        StringUtils.of((String)MDC.get((String)"callId")).or(() -> StringUtils.of((String)MDC.get((String)"jobId"))).or(() -> StringUtils.of((String)IdUtils.generateId())).ifPresent(callId -> requestBuilder.header("Nav-Call-Id", callId));
        EnvironmentUtils.getApplicationName().ifPresent(applicationName -> requestBuilder.header("Nav-Consumer-Id", applicationName));
        Request request = requestBuilder.method(original.method(), original.body()).build();
        String url = LogRequestInterceptor.toStringWithoutQuery(request.url());
        long requestStarted = System.currentTimeMillis();
        try {
            Response response = chain.proceed(request);
            long timeTakenMs = System.currentTimeMillis() - requestStarted;
            log.info(String.format("OUT status=%s method=%s time=%dms url=%s", response.code(), request.method(), timeTakenMs, url));
            return response;
        }
        catch (Throwable exception) {
            long timeTakenMs = System.currentTimeMillis() - requestStarted;
            log.error(String.format("Request failed: method=%s time=%dms url=%s", request.method(), timeTakenMs, url), exception);
            throw exception;
        }
    }

    private static String toStringWithoutQuery(HttpUrl url) {
        String urlStr = url.toString();
        int queryParamStart = urlStr.indexOf("?");
        if (queryParamStart < 0) {
            return urlStr;
        }
        return urlStr.substring(0, queryParamStart);
    }
}

