/*
 * Decompiled with CFR 0.152.
 */
package no.nav.common.rest.filter;

import java.io.IOException;
import java.util.Optional;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import no.nav.common.utils.IdUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public class LogRequestFilter
implements Filter {
    private static final Logger log = LoggerFactory.getLogger(LogRequestFilter.class);
    public static final String NAV_CONSUMER_ID_HEADER_NAME = "Nav-Consumer-Id";
    public static final String NAV_CALL_ID_HEADER_NAME = "Nav-Call-Id";
    private static final String SERVER_HEADER_NAME = "Server";
    private static final String RANDOM_USER_ID_COOKIE_NAME = "RUIDC";
    private static final String UNKNOWN_CONSUMER_ID = "unknown";
    private static final int ONE_MONTH_IN_SECONDS = 2592000;
    private final String applicationName;
    private final boolean exposeErrorDetails;

    public LogRequestFilter(String applicationName) {
        this(applicationName, false);
    }

    public LogRequestFilter(String applicationName, boolean exposeErrorDetails) {
        if (applicationName == null) {
            throw new IllegalArgumentException("Application name must not be null");
        }
        this.applicationName = applicationName;
        this.exposeErrorDetails = exposeErrorDetails;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        if (!(request instanceof HttpServletRequest) || !(response instanceof HttpServletResponse)) {
            throw new ServletException("LogRequestFilter supports only HTTP requests");
        }
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        if (LogRequestFilter.isInternalRequest(httpRequest)) {
            filterChain.doFilter((ServletRequest)httpRequest, (ServletResponse)httpResponse);
            return;
        }
        try {
            long requestStarted = System.currentTimeMillis();
            String consumerId = LogRequestFilter.resolveConsumerId(httpRequest);
            String callId = LogRequestFilter.resolveCallId(httpRequest);
            String userId = LogRequestFilter.resolveUserId(httpRequest).orElseGet(() -> {
                String newUserId = IdUtils.generateId();
                this.createUserIdCookie(newUserId, httpResponse);
                return newUserId;
            });
            MDC.put((String)"callId", (String)callId);
            MDC.put((String)"userId", (String)userId);
            MDC.put((String)"consumerId", (String)consumerId);
            MDC.put((String)"requestId", (String)IdUtils.generateId());
            httpResponse.setHeader(NAV_CALL_ID_HEADER_NAME, callId);
            httpResponse.setHeader(SERVER_HEADER_NAME, this.applicationName);
            this.filterChainWithErrorHandling(httpRequest, httpResponse, filterChain);
            long timeTakenMs = System.currentTimeMillis() - requestStarted;
            String requestLogMsg = String.format("IN status=%s method=%s time=%dms url=%s", httpResponse.getStatus(), httpRequest.getMethod(), timeTakenMs, httpRequest.getRequestURL());
            log.info(requestLogMsg);
        }
        finally {
            MDC.remove((String)"callId");
            MDC.remove((String)"userId");
            MDC.remove((String)"consumerId");
            MDC.remove((String)"requestId");
        }
    }

    private void filterChainWithErrorHandling(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws IOException {
        block3: {
            try {
                filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
            }
            catch (Throwable e) {
                log.error("Uncaught exception", e);
                if (response.isCommitted()) {
                    log.error("Response already committed, unable to set response error details");
                }
                response.setStatus(500);
                if (!this.exposeErrorDetails) break block3;
                e.printStackTrace(response.getWriter());
            }
        }
    }

    private void createUserIdCookie(String userId, HttpServletResponse httpResponse) {
        Cookie cookie = new Cookie(RANDOM_USER_ID_COOKIE_NAME, userId);
        cookie.setPath("/");
        cookie.setMaxAge(2592000);
        cookie.setHttpOnly(true);
        cookie.setSecure(true);
        httpResponse.addCookie(cookie);
    }

    private static boolean isInternalRequest(HttpServletRequest httpServletRequest) {
        return httpServletRequest.getRequestURI().contains("/internal/");
    }

    public static String resolveConsumerId(HttpServletRequest httpRequest) {
        return Optional.ofNullable(httpRequest.getHeader(NAV_CONSUMER_ID_HEADER_NAME)).filter(v -> !v.isBlank()).orElse(UNKNOWN_CONSUMER_ID);
    }

    public static String resolveCallId(HttpServletRequest httpRequest) {
        return Optional.ofNullable(httpRequest.getHeader(NAV_CALL_ID_HEADER_NAME)).filter(v -> !v.isBlank()).orElseGet(IdUtils::generateId);
    }

    private static Optional<String> resolveUserId(HttpServletRequest httpRequest) {
        return Optional.ofNullable(httpRequest.getCookies()).flatMap(cookies -> {
            for (Cookie cookie : cookies) {
                if (!RANDOM_USER_ID_COOKIE_NAME.equals(cookie.getName())) continue;
                return Optional.ofNullable(cookie.getValue());
            }
            return Optional.empty();
        });
    }

    public void init(FilterConfig filterConfig) {
    }

    public void destroy() {
    }
}

