/*
 * Decompiled with CFR 0.152.
 */
package no.nav.sbl.dialogarena.common.web.selftest.domain;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import no.nav.sbl.dialogarena.common.web.selftest.SelfTestStatus;
import no.nav.sbl.dialogarena.common.web.selftest.domain.SelftestResult;

public final class Selftest {
    private final String application;
    private final String version;
    private final String timestamp;
    private final SelfTestStatus aggregateResult;
    private final List<SelftestResult> checks;

    public List<SelftestResult> getChecks() {
        return Optional.ofNullable(this.checks).orElseGet(Collections::emptyList);
    }

    Selftest(String application, String version, String timestamp, SelfTestStatus aggregateResult, List<SelftestResult> checks) {
        this.application = application;
        this.version = version;
        this.timestamp = timestamp;
        this.aggregateResult = aggregateResult;
        this.checks = checks;
    }

    public static SelftestBuilder builder() {
        return new SelftestBuilder();
    }

    public String getApplication() {
        return this.application;
    }

    public String getVersion() {
        return this.version;
    }

    public String getTimestamp() {
        return this.timestamp;
    }

    public SelfTestStatus getAggregateResult() {
        return this.aggregateResult;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Selftest)) {
            return false;
        }
        Selftest other = (Selftest)o;
        String this$application = this.getApplication();
        String other$application = other.getApplication();
        if (this$application == null ? other$application != null : !this$application.equals(other$application)) {
            return false;
        }
        String this$version = this.getVersion();
        String other$version = other.getVersion();
        if (this$version == null ? other$version != null : !this$version.equals(other$version)) {
            return false;
        }
        String this$timestamp = this.getTimestamp();
        String other$timestamp = other.getTimestamp();
        if (this$timestamp == null ? other$timestamp != null : !this$timestamp.equals(other$timestamp)) {
            return false;
        }
        SelfTestStatus this$aggregateResult = this.getAggregateResult();
        SelfTestStatus other$aggregateResult = other.getAggregateResult();
        if (this$aggregateResult == null ? other$aggregateResult != null : !((Object)((Object)this$aggregateResult)).equals((Object)other$aggregateResult)) {
            return false;
        }
        List<SelftestResult> this$checks = this.getChecks();
        List<SelftestResult> other$checks = other.getChecks();
        return !(this$checks == null ? other$checks != null : !((Object)this$checks).equals(other$checks));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $application = this.getApplication();
        result = result * 59 + ($application == null ? 43 : $application.hashCode());
        String $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : $version.hashCode());
        String $timestamp = this.getTimestamp();
        result = result * 59 + ($timestamp == null ? 43 : $timestamp.hashCode());
        SelfTestStatus $aggregateResult = this.getAggregateResult();
        result = result * 59 + ($aggregateResult == null ? 43 : ((Object)((Object)$aggregateResult)).hashCode());
        List<SelftestResult> $checks = this.getChecks();
        result = result * 59 + ($checks == null ? 43 : ((Object)$checks).hashCode());
        return result;
    }

    public String toString() {
        return "Selftest(application=" + this.getApplication() + ", version=" + this.getVersion() + ", timestamp=" + this.getTimestamp() + ", aggregateResult=" + (Object)((Object)this.getAggregateResult()) + ", checks=" + this.getChecks() + ")";
    }

    public static class SelftestBuilder {
        private String application;
        private String version;
        private String timestamp;
        private SelfTestStatus aggregateResult;
        private List<SelftestResult> checks;

        SelftestBuilder() {
        }

        public SelftestBuilder application(String application) {
            this.application = application;
            return this;
        }

        public SelftestBuilder version(String version) {
            this.version = version;
            return this;
        }

        public SelftestBuilder timestamp(String timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public SelftestBuilder aggregateResult(SelfTestStatus aggregateResult) {
            this.aggregateResult = aggregateResult;
            return this;
        }

        public SelftestBuilder checks(List<SelftestResult> checks) {
            this.checks = checks;
            return this;
        }

        public Selftest build() {
            return new Selftest(this.application, this.version, this.timestamp, this.aggregateResult, this.checks);
        }

        public String toString() {
            return "Selftest.SelftestBuilder(application=" + this.application + ", version=" + this.version + ", timestamp=" + this.timestamp + ", aggregateResult=" + (Object)((Object)this.aggregateResult) + ", checks=" + this.checks + ")";
        }
    }
}

